/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.util.file.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HtmlDomSerializer {
    public void write(Document document, File file, Charset charset) {
        try {
            FileUtil.createDir((File)file.getParentFile());
            FileWriter writer = new FileWriter(file, charset);
            BufferedWriter buf = new BufferedWriter(writer);
            this.write(document.getDocumentElement(), buf);
            buf.close();
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    public void write(Node nodeToWrite, Writer writer) throws IOException {
        Element element = null;
        if (nodeToWrite instanceof Element) {
            element = (Element)nodeToWrite;
        } else if (nodeToWrite instanceof Document) {
            element = ((Document)nodeToWrite).getDocumentElement();
        } else {
            return;
        }
        writer.append(String.format("<%s ", element.getTagName()));
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            writer.append(String.format("%s=\"%s\" ", node.getNodeName(), node.getNodeValue()));
            ++i;
        }
        writer.append(">");
        if (!element.getTagName().equalsIgnoreCase("a")) {
            this.nl(writer);
        }
        NodeList nodes = element.getChildNodes();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Node node = nodes.item(i2);
            if (node instanceof Text) {
                writer.append(node.getNodeValue());
            }
            if (node instanceof Element) {
                this.write((Element)node, writer);
            }
            ++i2;
        }
        if (!this.isSelfClosing(element.getTagName())) {
            writer.append(String.format("</%s>", element.getTagName()));
            if (!element.getTagName().equalsIgnoreCase("a")) {
                this.nl(writer);
            }
        }
    }

    private boolean isSelfClosing(String tagname) {
        return tagname.equalsIgnoreCase("br") || tagname.equalsIgnoreCase("br");
    }

    private void nl(Writer writer) throws IOException {
        writer.append("\n");
    }
}

