/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import net.edgemind.ibee.core.log.LogUtil;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.wml.CTLongHexNumber;
import org.docx4j.wml.Color;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.Lvl;
import org.docx4j.wml.NumFmt;
import org.docx4j.wml.NumberFormat;
import org.docx4j.wml.Numbering;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STHint;
import org.docx4j.wml.U;
import org.docx4j.wml.UnderlineEnumeration;

public class AbstractNumHelper {
    private Integer fixTitleSize = null;

    public void setTitleSize(Integer fixTitleSize) {
        this.fixTitleSize = fixTitleSize;
    }

    public void createAbstractNum(WordprocessingMLPackage wordMLPackage) {
        NumberingDefinitionsPart ndp = wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        this.createNumberingAbstractNum(ndp);
        this.createBulletAbstractNum(ndp);
        this.createBullet2AbstractNum(ndp);
    }

    protected void createNumberingAbstractNum(NumberingDefinitionsPart ndp) {
        Numbering.AbstractNum numberingabstractnum = Context.getWmlObjectFactory().createNumberingAbstractNum();
        ndp.addAbstractListNumberingDefinition(numberingabstractnum);
        numberingabstractnum.setAbstractNumId(BigInteger.valueOf(2L));
        CTLongHexNumber longhexnumber = Context.getWmlObjectFactory().createCTLongHexNumber();
        numberingabstractnum.setNsid(longhexnumber);
        longhexnumber.setVal("6ECB300A");
        Numbering.AbstractNum.MultiLevelType numberingabstractnummultileveltype = Context.getWmlObjectFactory().createNumberingAbstractNumMultiLevelType();
        numberingabstractnum.setMultiLevelType(numberingabstractnummultileveltype);
        numberingabstractnummultileveltype.setVal("multilevel");
        CTLongHexNumber longhexnumber2 = Context.getWmlObjectFactory().createCTLongHexNumber();
        numberingabstractnum.setTmpl(longhexnumber2);
        longhexnumber2.setVal("040C001F");
        numberingabstractnum.getLvl().clear();
        int i = 0;
        while (i < 9) {
            numberingabstractnum.getLvl().add(i, this.createNumberingLevel(i));
            ++i;
        }
        Numbering numbering = Context.getWmlObjectFactory().createNumbering();
        numbering.getAbstractNum().add(numberingabstractnum);
        Numbering.Num numberingnum = Context.getWmlObjectFactory().createNumberingNum();
        numbering.getNum().add(numberingnum);
        Numbering.Num.AbstractNumId numberingnumabstractnumid = Context.getWmlObjectFactory().createNumberingNumAbstractNumId();
        numberingnum.setAbstractNumId(numberingnumabstractnumid);
        numberingnumabstractnumid.setVal(BigInteger.valueOf(2L));
        numberingnum.setNumId(BigInteger.valueOf(2L));
    }

    protected void createBulletAbstractNum(NumberingDefinitionsPart ndp) {
        Numbering.AbstractNum numberingabstractnum = Context.getWmlObjectFactory().createNumberingAbstractNum();
        ndp.addAbstractListNumberingDefinition(numberingabstractnum);
        numberingabstractnum.setAbstractNumId(BigInteger.valueOf(3L));
        CTLongHexNumber longhexnumber = Context.getWmlObjectFactory().createCTLongHexNumber();
        numberingabstractnum.setNsid(longhexnumber);
        longhexnumber.setVal("626A5A7A");
        Numbering.AbstractNum.MultiLevelType numberingabstractnummultileveltype = Context.getWmlObjectFactory().createNumberingAbstractNumMultiLevelType();
        numberingabstractnum.setMultiLevelType(numberingabstractnummultileveltype);
        numberingabstractnummultileveltype.setVal("hybridMultilevel");
        CTLongHexNumber longhexnumber2 = Context.getWmlObjectFactory().createCTLongHexNumber();
        numberingabstractnum.setTmpl(longhexnumber2);
        longhexnumber2.setVal("6480E1DA");
        numberingabstractnum.getLvl().clear();
        int i = 0;
        while (i < 9) {
            numberingabstractnum.getLvl().add(i, this.createBulletLevel(i));
            ++i;
        }
        Numbering numbering = Context.getWmlObjectFactory().createNumbering();
        numbering.getAbstractNum().add(numberingabstractnum);
        Numbering.Num numberingnum = Context.getWmlObjectFactory().createNumberingNum();
        numbering.getNum().add(numberingnum);
        Numbering.Num.AbstractNumId numberingnumabstractnumid = Context.getWmlObjectFactory().createNumberingNumAbstractNumId();
        numberingnum.setAbstractNumId(numberingnumabstractnumid);
        numberingnumabstractnumid.setVal(BigInteger.valueOf(3L));
        numberingnum.setNumId(BigInteger.valueOf(3L));
    }

    protected void createBullet2AbstractNum(NumberingDefinitionsPart ndp) {
        Numbering.AbstractNum numberingabstractnum = Context.getWmlObjectFactory().createNumberingAbstractNum();
        ndp.addAbstractListNumberingDefinition(numberingabstractnum);
        numberingabstractnum.setAbstractNumId(BigInteger.valueOf(4L));
        CTLongHexNumber longhexnumber = Context.getWmlObjectFactory().createCTLongHexNumber();
        numberingabstractnum.setNsid(longhexnumber);
        longhexnumber.setVal("626A5A7A");
        Numbering.AbstractNum.MultiLevelType numberingabstractnummultileveltype = Context.getWmlObjectFactory().createNumberingAbstractNumMultiLevelType();
        numberingabstractnum.setMultiLevelType(numberingabstractnummultileveltype);
        numberingabstractnummultileveltype.setVal("hybridMultilevel");
        CTLongHexNumber longhexnumber2 = Context.getWmlObjectFactory().createCTLongHexNumber();
        numberingabstractnum.setTmpl(longhexnumber2);
        longhexnumber2.setVal("6480E1DA");
        numberingabstractnum.getLvl().clear();
        int i = 0;
        while (i < 9) {
            numberingabstractnum.getLvl().add(i, this.createBullet2Level(i));
            ++i;
        }
        Numbering numbering = Context.getWmlObjectFactory().createNumbering();
        numbering.getAbstractNum().add(numberingabstractnum);
        Numbering.Num numberingnum = Context.getWmlObjectFactory().createNumberingNum();
        numbering.getNum().add(numberingnum);
        Numbering.Num.AbstractNumId numberingnumabstractnumid = Context.getWmlObjectFactory().createNumberingNumAbstractNumId();
        numberingnum.setAbstractNumId(numberingnumabstractnumid);
        numberingnumabstractnumid.setVal(BigInteger.valueOf(4L));
        numberingnum.setNumId(BigInteger.valueOf(4L));
    }

    protected Lvl createNumberingLevel(int level) {
        Lvl lvl = Context.getWmlObjectFactory().createLvl();
        lvl.setIlvl(BigInteger.valueOf(level));
        Lvl.Start lvlstart = Context.getWmlObjectFactory().createLvlStart();
        lvl.setStart(lvlstart);
        lvlstart.setVal(BigInteger.valueOf(1L));
        NumFmt numfmt = Context.getWmlObjectFactory().createNumFmt();
        lvl.setNumFmt(numfmt);
        numfmt.setVal(NumberFormat.DECIMAL);
        Lvl.LvlText lvllvltext = Context.getWmlObjectFactory().createLvlLvlText();
        lvl.setLvlText(lvllvltext);
        Object value = "";
        int i = 0;
        while (i < level + 1) {
            value = (String)value + "%" + (i + 1) + ".";
            ++i;
        }
        lvllvltext.setVal((String)value);
        Jc jc = Context.getWmlObjectFactory().createJc();
        lvl.setLvlJc(jc);
        jc.setVal(JcEnumeration.LEFT);
        PPr ppr = Context.getWmlObjectFactory().createPPr();
        lvl.setPPr(ppr);
        ppr.setInd(this.createIndent(level));
        RPr rpr = Context.getWmlObjectFactory().createRPr();
        lvl.setRPr(rpr);
        RFonts rfonts = Context.getWmlObjectFactory().createRFonts();
        rpr.setRFonts(rfonts);
        rfonts.setHint(STHint.DEFAULT);
        if (level == 0) {
            c = new Color();
            c.setVal("FF0000");
            rpr.setColor(c);
            U underline = new U();
            underline.setVal(UnderlineEnumeration.SINGLE);
            rpr.setU(underline);
            HpsMeasure size = new HpsMeasure();
            size.setVal(new BigInteger("36"));
            rpr.setSz(size);
        } else {
            c = new Color();
            c.setVal("008000");
            rpr.setColor(c);
            HpsMeasure size = new HpsMeasure();
            size.setVal(new BigInteger("32"));
            rpr.setSz(size);
        }
        if (this.fixTitleSize != null) {
            HpsMeasure size = new HpsMeasure();
            size.setVal(new BigInteger(String.valueOf(this.fixTitleSize)));
            rpr.setSz(size);
        }
        return lvl;
    }

    protected Lvl createBulletLevel(int level) {
        Lvl lvl = Context.getWmlObjectFactory().createLvl();
        lvl.setIlvl(BigInteger.valueOf(level));
        Lvl.Start lvlstart = Context.getWmlObjectFactory().createLvlStart();
        lvl.setStart(lvlstart);
        lvlstart.setVal(BigInteger.valueOf(1L));
        NumFmt numfmt = Context.getWmlObjectFactory().createNumFmt();
        lvl.setNumFmt(numfmt);
        numfmt.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext = Context.getWmlObjectFactory().createLvlLvlText();
        lvl.setLvlText(lvllvltext);
        String value = "*";
        if (level % 2 == 0) {
            try {
                byte[] utf8Bytes = new byte[]{-17, -126, -73};
                value = new String(utf8Bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            value = "o";
        }
        lvllvltext.setVal(value);
        Jc jc = Context.getWmlObjectFactory().createJc();
        lvl.setLvlJc(jc);
        jc.setVal(JcEnumeration.LEFT);
        PPr ppr = Context.getWmlObjectFactory().createPPr();
        lvl.setPPr(ppr);
        ppr.setInd(this.createIndent(level));
        RPr rpr = Context.getWmlObjectFactory().createRPr();
        lvl.setRPr(rpr);
        RFonts rfonts = Context.getWmlObjectFactory().createRFonts();
        rpr.setRFonts(rfonts);
        if (level % 2 == 0) {
            rfonts.setAscii("Symbol");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Symbol");
        } else {
            rfonts.setAscii("Courier New");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Courier New");
            rfonts.setCs("Courier New");
        }
        return lvl;
    }

    protected Lvl createBullet2Level(int level) {
        Lvl lvl = Context.getWmlObjectFactory().createLvl();
        lvl.setIlvl(BigInteger.valueOf(level));
        Lvl.Start lvlstart = Context.getWmlObjectFactory().createLvlStart();
        lvl.setStart(lvlstart);
        lvlstart.setVal(BigInteger.valueOf(1L));
        NumFmt numfmt = Context.getWmlObjectFactory().createNumFmt();
        lvl.setNumFmt(numfmt);
        numfmt.setVal(NumberFormat.BULLET);
        Lvl.LvlText lvllvltext = Context.getWmlObjectFactory().createLvlLvlText();
        lvl.setLvlText(lvllvltext);
        String value = "*";
        if (level % 2 == 0) {
            try {
                byte[] utf8Bytes = new byte[]{-17, -126, -73};
                value = new String(utf8Bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.log((Throwable)e);
            }
        } else {
            value = "o";
        }
        lvllvltext.setVal(value);
        Jc jc = Context.getWmlObjectFactory().createJc();
        lvl.setLvlJc(jc);
        jc.setVal(JcEnumeration.LEFT);
        PPr ppr = Context.getWmlObjectFactory().createPPr();
        lvl.setPPr(ppr);
        ppr.setInd(this.createIndent(level + 8));
        RPr rpr = Context.getWmlObjectFactory().createRPr();
        lvl.setRPr(rpr);
        RFonts rfonts = Context.getWmlObjectFactory().createRFonts();
        rpr.setRFonts(rfonts);
        if (level % 2 == 0) {
            rfonts.setAscii("Symbol");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Symbol");
        } else {
            rfonts.setAscii("Courier New");
            rfonts.setHint(STHint.DEFAULT);
            rfonts.setHAnsi("Courier New");
            rfonts.setCs("Courier New");
        }
        return lvl;
    }

    protected PPrBase.Ind createIndent(int level) {
        PPrBase.Ind ind = Context.getWmlObjectFactory().createPPrBaseInd();
        ind.setLeft(BigInteger.valueOf(360 * (level + 1) + 72));
        ind.setHanging(BigInteger.valueOf(360 + 72 * level));
        return ind;
    }
}

