/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import java.io.File;
import java.util.List;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Text;

public class AddingAFooter {
    private WordprocessingMLPackage wordMLPackage;
    private ObjectFactory factory;

    public void main(String[] args) throws Docx4JException {
        this.wordMLPackage = WordprocessingMLPackage.createPackage();
        this.factory = Context.getWmlObjectFactory();
        Relationship relationship = this.createFooterPart();
        this.createFooterReference(relationship);
        this.wordMLPackage.getMainDocumentPart().addParagraphOfText("Hello Word!");
        this.wordMLPackage.save(new File("src/main/files/HelloWord14.docx"));
    }

    private Relationship createFooterPart() throws InvalidFormatException {
        FooterPart footerPart = new FooterPart();
        footerPart.setPackage((OpcPackage)this.wordMLPackage);
        footerPart.setJaxbElement((Object)this.createFooter("Text"));
        return this.wordMLPackage.getMainDocumentPart().addTargetPart((Part)footerPart);
    }

    private Ftr createFooter(String content) {
        Ftr footer = this.factory.createFtr();
        P paragraph = this.factory.createP();
        R run = this.factory.createR();
        Text text = new Text();
        text.setValue(content);
        run.getContent().add(text);
        paragraph.getContent().add(run);
        footer.getContent().add(paragraph);
        return footer;
    }

    private void createFooterReference(Relationship relationship) {
        List sections = this.wordMLPackage.getDocumentModel().getSections();
        SectPr sectionProperties = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectionProperties == null) {
            sectionProperties = this.factory.createSectPr();
            this.wordMLPackage.getMainDocumentPart().addObject((Object)sectionProperties);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectionProperties);
        }
        FooterReference footerReference = this.factory.createFooterReference();
        footerReference.setId(relationship.getId());
        footerReference.setType(HdrFtrRef.DEFAULT);
        sectionProperties.getEGHdrFtrReferences().add(footerReference);
    }
}

