/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.dita.writer.word;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.edgemind.ibee.util.file.FileUtil;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;

public class AddingAnInlineImageToTable {
    public static void addImage(String path, Tr tr, WordprocessingMLPackage pack) throws Exception {
        File file = new File(path);
        P paragraphWithImage = AddingAnInlineImageToTable.addInlineImageToParagraph(AddingAnInlineImageToTable.createInlineImage(file, pack));
        AddingAnInlineImageToTable.addTableCell(tr, paragraphWithImage);
    }

    private static void addTableCell(Tr tr, P paragraph) {
        Tc tc1 = new Tc();
        tc1.getContent().add(paragraph);
        tr.getContent().add(tc1);
    }

    private static P addInlineImageToParagraph(Inline inline) {
        ObjectFactory factory = new ObjectFactory();
        P paragraph = factory.createP();
        R run = factory.createR();
        paragraph.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        return paragraph;
    }

    private static Inline createInlineImage(File file, WordprocessingMLPackage wordMLPackage) throws Exception {
        byte[] bytes = AddingAnInlineImageToTable.convertImageToByteArray(file);
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((WordprocessingMLPackage)wordMLPackage, (byte[])bytes);
        int docPrId = 1;
        int cNvPrId = 2;
        return imagePart.createImageInline("Filename hint", "Alternative text", (long)docPrId, cNvPrId, false);
    }

    private static byte[] convertImageToByteArray(File file) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = FileUtil.openInputStream((File)file);){
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                System.out.println("File too large!!");
            }
            byte[] bytes = new byte[(int)length];
            int offset = 0;
            int numRead = 0;
            while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            if (offset < bytes.length) {
                System.out.println("Could not completely read file " + file.getName());
            }
            return bytes;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

