/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.genpython;

public class PythonBuf {
    private StringBuffer buf = new StringBuffer();
    private int lineNr = 1;
    private boolean showLineNumbers = false;
    private boolean beginOfLine = true;
    private int nrSpaces = 4;
    private int currentIndent = 0;

    public PythonBuf setIndentNrSpaces(int nrSpaces) {
        this.nrSpaces = nrSpaces;
        return this;
    }

    public PythonBuf reset() {
        this.buf = new StringBuffer();
        this.lineNr = 1;
        this.beginOfLine = true;
        return this;
    }

    public void showLineNumbers(boolean value) {
        this.showLineNumbers = value;
    }

    public String getText() {
        return this.buf.toString();
    }

    public PythonBuf nl() {
        this.write("\n", this.currentIndent);
        ++this.lineNr;
        this.beginOfLine = true;
        return this;
    }

    public PythonBuf write(String line) {
        this.write(line, this.currentIndent);
        return this;
    }

    private PythonBuf write(String line, int indent) {
        if (this.beginOfLine && this.showLineNumbers) {
            this.buf.append(this.lineNr + ": ");
        }
        this.beginOfLine = false;
        int i = 0;
        while (i < indent * this.nrSpaces) {
            this.buf.append(" ");
            ++i;
        }
        this.buf.append(line);
        return this;
    }

    public PythonBuf writeln(PythonBuf buf) {
        String[] lines;
        String[] stringArray = lines = buf.getText().split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.writeln(line);
            ++n2;
        }
        this.nl();
        return this;
    }

    public PythonBuf writeln(String line) {
        this.writeln(line, this.currentIndent);
        return this;
    }

    private PythonBuf writeln(String line, int indent) {
        this.write(line, indent);
        this.nl();
        return this;
    }

    public PythonBuf enter() {
        ++this.currentIndent;
        return this;
    }

    public PythonBuf leave() {
        --this.currentIndent;
        return this;
    }
}

