/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.genpython;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.edgemind.ibee.genpython.PythonClass;
import net.edgemind.ibee.genpython.PythonFile;
import net.edgemind.ibee.genpython.PythonImport;
import net.edgemind.ibee.util.file.FileUtil;

public class PythonProgram {
    private List<PythonFile> files = new ArrayList<PythonFile>();
    private static HashMap<String, PythonImport> sIncludeMap = new HashMap();

    public PythonFile addFile(PythonFile file) {
        this.files.add(file);
        return file;
    }

    public List<PythonFile> getFiles() {
        return this.files;
    }

    public void removeFile(PythonFile file) {
        this.files.remove(file);
    }

    public PythonFile getFile(String name) {
        return this.getFile(name, false);
    }

    public PythonFile getFile(String name, boolean create) {
        name = FileUtil.replaceExtension((String)name, null);
        for (PythonFile file : this.files) {
            if (!file.getName().equals(name)) continue;
            return file;
        }
        if (create) {
            PythonFile file;
            file = new PythonFile(name);
            this.addFile(file);
            return file;
        }
        return null;
    }

    public PythonClass findClass(String name) {
        for (PythonFile file : this.files) {
            PythonClass clazz = file.getClass(name);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public static HashMap<String, PythonImport> getIncludeMap() {
        return sIncludeMap;
    }

    public static void addImportFromDir(String dirPath) {
        List files;
        File dir = new File(dirPath.trim());
        if (!dir.exists()) {
            throw new RuntimeException("project " + dirPath + " not found");
        }
        try {
            files = FileUtil.readFilesFromDir((File)dir, (boolean)true, (String)"\\w*\\.java");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (File javaFile : files) {
            int index;
            String name = javaFile.getName();
            name = name.replaceAll(".java", "");
            String path = javaFile.getAbsolutePath();
            path = path.replaceAll(".java", "");
            if (name.startsWith("I")) {
                name = name.substring(1);
            }
            if (sIncludeMap.containsKey("_" + name) || (index = (path = path.replaceAll("\\\\", "/")).lastIndexOf("/src/")) < 0) continue;
            path = path.substring(index + "/src/".length(), path.length());
            path = path.replaceAll("/", ".");
            PythonImport pythonImport = new PythonImport();
            Object packageName = "";
            String className = name;
            String aliasName = "_" + name;
            String[] paths = path.split("\\.");
            int i = 0;
            while (i < paths.length - 1) {
                packageName = (String)packageName + paths[i] + ".";
                ++i;
            }
            packageName = ((String)packageName).substring(0, ((String)packageName).length() - 1);
            pythonImport.setPackageName((String)packageName);
            pythonImport.setClazzName(className);
            pythonImport.setAlias(aliasName);
            System.out.println("add Import " + name + "->" + path);
            sIncludeMap.put(aliasName, pythonImport);
        }
    }
}

