/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.genpython;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.genpython.PythonClass;
import net.edgemind.ibee.genpython.PythonFile;
import net.edgemind.ibee.genpython.PythonImport;
import net.edgemind.ibee.genpython.PythonProgram;
import net.edgemind.ibee.util.file.FileUtil;

public class PythonProgramScanner {
    private PythonFile currentFile;
    private PythonClass currentClass;
    private int currentLineNr;
    private String currentLine;
    private PythonProgram program = new PythonProgram();
    private Map<PythonClass, List<String>> inheritations = new HashMap<PythonClass, List<String>>();

    public PythonProgram scanDir(String bdcDir) throws IOException {
        List files = FileUtil.readFiles((String)bdcDir, (Boolean)true, (String)"\\.py$", (String)(bdcDir + File.separator));
        for (String file : files) {
            this.scan(file);
        }
        this.postProcessing();
        return this.program;
    }

    public PythonProgram scanFile(String bdcFile) throws IOException {
        this.scan(bdcFile);
        this.postProcessing();
        return this.program;
    }

    private void scan(String filePath) throws IOException {
        PythonFile file;
        String name = FileUtil.extractFileName((String)filePath);
        String dir = FileUtil.extractFileDir((String)filePath);
        this.currentFile = file = this.program.getFile(name, true);
        BufferedReader reader = new BufferedReader(new FileReader(dir + File.separator + name));
        this.currentLineNr = 0;
        this.currentClass = null;
        while ((this.currentLine = reader.readLine()) != null) {
            ++this.currentLineNr;
            this.currentLine = this.currentLine.trim();
            if (this.currentLine.equals("") || this.currentLine.startsWith("#")) continue;
            if (this.currentLine.startsWith("import")) {
                this.scanImport(this.currentLine);
            }
            if (this.currentLine.startsWith("from")) {
                this.scanImport2(this.currentLine);
            }
            if (this.currentLine.startsWith("class ")) {
                this.currentClass = this.scanClass(this.currentLine);
            }
            if (this.currentClass == null) continue;
            this.currentClass.buf.writeln(this.currentLine);
        }
        reader.close();
    }

    private void scanImport(String line) throws IOException {
        String[] args = line.trim().split("\\s+");
        if (args.length <= 1) {
            LogUtil.log((String)("Corrupt import '" + line + "',...skip line"), (LogLevel)LogLevel.ERROR);
            return;
        }
        String packageName = args[1];
        String clazzName = null;
        PythonImport pythonImport = new PythonImport();
        this.currentFile.addImport(pythonImport);
        pythonImport.setPackageName(packageName);
        pythonImport.setClazzName(clazzName);
        pythonImport.setAlias(packageName);
        if (args.length >= 4) {
            if (!args[2].equals("as")) {
                LogUtil.log((String)("Corrupt import '" + line + "'"), (LogLevel)LogLevel.ERROR);
            }
            String alias = args[3];
            pythonImport.setAlias(alias);
        }
    }

    private void scanImport2(String line) throws IOException {
        String[] args = line.trim().split("\\s+");
        if (args.length < 4) {
            LogUtil.log((String)("Corrupt import '" + line + "',...skip line"), (LogLevel)LogLevel.ERROR);
            return;
        }
        if (!args[2].equals("import")) {
            LogUtil.log((String)("Corrupt import '" + line + "'"), (LogLevel)LogLevel.ERROR);
        }
        String packageName = args[1];
        String clazzName = args[3];
        clazzName.equals("*");
        PythonImport pythonImport = new PythonImport();
        this.currentFile.addImport(pythonImport);
        pythonImport.setPackageName(packageName);
        pythonImport.setClazzName(clazzName);
        pythonImport.setAlias(clazzName);
        if (args.length > 4) {
            if (!args[2].equals("as")) {
                LogUtil.log((String)("Corrupt import '" + line + "'"), (LogLevel)LogLevel.ERROR);
            }
            String alias = args[5];
            pythonImport.setAlias(alias);
        }
    }

    private PythonClass scanClass(String line) throws IOException {
        String className = this.extractClassName(line);
        List<String> args = this.extractArguments(line);
        PythonClass clazz = this.currentFile.getClass(className, true);
        this.inheritations.put(clazz, args);
        return clazz;
    }

    private void postProcessing() {
        this.developImports();
        this.determineInheritations();
    }

    private void developImports() {
        for (PythonFile file : new ArrayList<PythonFile>(this.program.getFiles())) {
            ArrayList<PythonImport> newImports = new ArrayList<PythonImport>();
            for (PythonImport pImport : file.getImports()) {
                if (pImport.getClazzName() != null && pImport.getClazzName().equals("*")) {
                    PythonFile importedFile = this.program.getFile(pImport.getPackageName());
                    if (importedFile != null) {
                        for (PythonClass importedClazz : new ArrayList<PythonClass>(importedFile.getClasses())) {
                            PythonImport newImport = new PythonImport();
                            newImport.setPackageName(pImport.getPackageName());
                            newImport.setClazzName(importedClazz.getName());
                            newImport.setAlias(importedClazz.getName());
                            newImports.add(newImport);
                        }
                        continue;
                    }
                    LogUtil.log((String)("Import " + pImport.getPackageName() + " not found"), (LogLevel)LogLevel.ERROR);
                    continue;
                }
                newImports.add(pImport);
            }
            file.setImports(newImports);
        }
    }

    private void determineInheritations() {
        for (PythonFile file : new ArrayList<PythonFile>(this.program.getFiles())) {
            for (PythonClass clazz : file.getClasses()) {
                List<String> args = this.inheritations.get(clazz);
                if (args == null || args.size() <= 0) continue;
                this.resolveInheritations(clazz, args);
            }
        }
    }

    private void resolveInheritations(PythonClass clazz, List<String> args) {
        PythonFile currentFile = clazz.getFile();
        for (String arg : args) {
            String inheritedClassName;
            PythonFile fileThatContainsImportedClass = null;
            String packageName = null;
            int index = arg.lastIndexOf(".");
            if (index >= 0) {
                alias = arg.substring(0, index);
                pythonImport = currentFile.getImportFromAlias(alias);
                packageName = pythonImport.getPackageName();
                inheritedClassName = arg.substring(index + 1);
            } else {
                inheritedClassName = arg;
                alias = inheritedClassName;
                pythonImport = currentFile.getImportFromAlias(alias);
                packageName = pythonImport != null ? pythonImport.getPackageName() : currentFile.getName();
            }
            fileThatContainsImportedClass = this.program.getFile(packageName, true);
            PythonClass inheritedClass = fileThatContainsImportedClass.getClass(inheritedClassName, true);
            clazz.addInheritation(inheritedClass);
        }
    }

    private String extractClassName(String expr) throws IOException {
        int begin = -1;
        int end = -1;
        int index = expr.indexOf("class");
        begin = index >= 0 ? index + "class".length() : 0;
        index = expr.indexOf("(");
        end = index >= 0 ? index : ((index = expr.indexOf(":")) >= 0 ? index : expr.length());
        return expr.substring(begin, end).trim();
    }

    private List<String> extractFunctionName(String expr) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        boolean found = false;
        int index = 0;
        while (index < expr.length()) {
            char c = expr.charAt(index);
            if (c == '(') {
                found = true;
                break;
            }
            ++index;
        }
        if (!found) {
            return result;
        }
        expr = expr.substring(0, index);
        --index;
        Object current = "";
        while (index >= 0) {
            char c = expr.charAt(index);
            if (c == '.') {
                if (((String)current).length() > 0) {
                    result.add(0, ((String)current).trim());
                }
                current = "";
            } else {
                if (!Character.isAlphabetic(c) && !Character.isDigit(c)) break;
                current = c + (String)current;
            }
            --index;
        }
        if (((String)current).length() > 0) {
            result.add(0, ((String)current).trim());
        }
        return result;
    }

    private List<String> extractArguments(String expr) {
        ArrayList<String> result = new ArrayList<String>();
        boolean scan = false;
        boolean recordString = false;
        Object current = "";
        int i = 0;
        while (i < expr.length()) {
            char c = expr.charAt(i);
            if (!scan) {
                if (c == '(') {
                    scan = true;
                }
            } else if (c == '\"') {
                recordString = !recordString;
            } else if (recordString) {
                current = (String)current + c;
            } else {
                if (c == ')') break;
                if (c == ',') {
                    if (((String)current).length() > 0) {
                        result.add((String)current);
                    }
                    current = "";
                } else if (!Character.isWhitespace(c)) {
                    current = (String)current + c;
                }
            }
            ++i;
        }
        if (((String)current).length() > 0) {
            result.add((String)current);
        }
        return result;
    }

    private void err(String s) {
        System.err.println(this.currentFile.getName() + ":" + this.currentLineNr + ":" + this.currentLine + ":" + s);
    }

    private void log(String s) {
        System.out.println(this.currentFile.getName() + ":" + this.currentLineNr + ":" + s);
    }

    public PythonProgram getProgram() {
        return this.program;
    }
}

