/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.model.converter;

import java.util.ArrayList;
import net.edgemind.ibee.core.iml.domain.Version;
import net.edgemind.ibee.core.log.LogableAndMonitored;
import net.ibee.gmf.model.IGmfAttribute;
import net.ibee.gmf.model.IGmfComponent;
import net.ibee.gmf.model.IGmfElement;
import net.ibee.gmf.model.IGmfLibrary;
import net.ibee.gmf.model.IGmfList;
import net.ibee.gmf.model.IGmfMeta;
import net.ibee.gmf.model.IGmfModel;

public abstract class AbstractGmfConverter
extends LogableAndMonitored {
    public abstract Version getToVersion();

    public void convert(IGmfModel model) {
        this.pre(model);
        this.covertModel(model);
        this.post(model);
    }

    protected void pre(IGmfModel model) {
    }

    protected void covertModel(IGmfModel model) {
        this.interruptIfCancelled();
        this.covertMeta(model);
        this.convertLibraries(model);
        ArrayList<IGmfComponent> components = new ArrayList<IGmfComponent>(model.getComponents());
        for (IGmfComponent component : components) {
            this.convertComponent(component);
        }
    }

    protected void post(IGmfModel model) {
    }

    protected void covertMeta(IGmfModel model) {
        for (IGmfMeta meta : model.getMeta()) {
            this.convertMetaData(meta, model);
        }
    }

    protected void convertComponent(IGmfComponent component) {
        this.interruptIfCancelled();
        for (IGmfAttribute attrFrom : new ArrayList<IGmfAttribute>(component.getAttributes())) {
            this.convertAttribute(attrFrom, component);
        }
        for (IGmfList listFrom : new ArrayList<IGmfList>(component.getLists())) {
            this.convertListFeature(listFrom, component);
        }
        for (IGmfElement elFeature : new ArrayList<IGmfElement>(component.getElements())) {
            this.convertElementFeature(elFeature, component);
        }
    }

    protected void convertLibraries(IGmfModel model) {
        for (IGmfLibrary lib : model.getLibrary()) {
            this.convertLibrary(lib);
        }
    }

    protected void convertAttribute(IGmfAttribute attr, IGmfComponent component) {
    }

    protected void convertElementFeature(IGmfElement elFeature, IGmfComponent component) {
    }

    protected void convertListFeature(IGmfList listFeature, IGmfComponent component) {
    }

    protected void convertMetaData(IGmfMeta meta, IGmfModel model) {
    }

    protected void convertLibrary(IGmfLibrary library) {
    }
}

