/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.ibee.gmf.model.IGmfComponent;
import net.ibee.gmf.model.IGmfElement;
import net.ibee.gmf.model.IGmfList;
import net.ibee.gmf.model.IGmfModel;
import net.ibee.gmf.model.IGmfRef;
import net.ibee.gmf.util.GmfHelper;

public class GmfResolver {
    Map<Long, IGmfComponent> cache = null;
    GmfHelper helper;

    public GmfResolver(IbeeResource resource, GmfHelper helper) {
        this.helper = helper;
    }

    protected void setHelper(GmfHelper helper) {
        this.helper = helper;
    }

    protected void initCache(IbeeResource resource) {
        this.cache = new HashMap<Long, IGmfComponent>();
        IGmfModel model = this.helper.getModel(resource);
        if (model != null) {
            for (IGmfComponent component : model.getComponents()) {
                this.cache.put(component.getId(), component);
            }
        }
    }

    public IGmfComponent resolve(IGmfRef ref, IbeeResource resource) {
        if (ref == null) {
            return null;
        }
        return this.resolve(ref.getId(), resource);
    }

    public IGmfComponent resolve(Long refId, IbeeResource resource) {
        if (refId == null) {
            return null;
        }
        return this.cache.get(refId);
    }

    public List<IGmfComponent> resolveList(String listName, IGmfComponent parent) {
        return this.resolveList(this.helper.getList(listName, parent));
    }

    public List<IGmfComponent> resolveList(IGmfList listFeature) {
        if (listFeature == null) {
            return new ArrayList<IGmfComponent>();
        }
        List<IGmfRef> refList = listFeature.getRef();
        if (refList == null) {
            return new ArrayList<IGmfComponent>();
        }
        return refList.stream().map(ref -> this.resolve((IGmfRef)ref, listFeature.giGetResource())).collect(Collectors.toList());
    }

    public IGmfComponent resolveElement(String elFeature, IGmfComponent parent) {
        return this.resolveElement(this.helper.getElement(elFeature, parent));
    }

    public IGmfComponent resolveElement(IGmfElement elFeature) {
        if (elFeature == null) {
            return null;
        }
        return this.resolve(elFeature.getRef(), elFeature.giGetResource());
    }

    public void resetCache(IbeeResource resource) {
        this.initCache(resource);
    }
}

