/*
 * Decompiled with CFR 0.152.
 */
package net.ibee.gmf.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.edgemind.ibee.core.resource.IbeeResource;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import net.ibee.gmf.model.IGmfAttribute;
import net.ibee.gmf.model.IGmfComponent;
import net.ibee.gmf.model.IGmfElement;
import net.ibee.gmf.model.IGmfLibrary;
import net.ibee.gmf.model.IGmfList;
import net.ibee.gmf.model.IGmfMeta;
import net.ibee.gmf.model.IGmfModel;
import net.ibee.gmf.model.IGmfRef;
import net.ibee.gmf.util.GmfHelper;

public class SaxGmfWriter {
    int indent = 0;
    XMLStreamWriter writer;
    IbeeResource resource;
    GmfHelper resolver;

    public void write(IGmfModel model, File file) throws IOException {
        this.resolver = new GmfHelper(model.giGetResource());
        OutputStream outputStream = this.createZippedFileOutput(file);
        this.resource = model.giGetResource();
        try {
            try {
                this.writer = XmlUtil.createStreamWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"));
                this.writer.writeStartDocument();
                this.nl();
                this.writer.writeStartElement("resource");
                ++this.indent;
                this.writeMetaSection(model);
                this.writeLibraries(model);
                this.writeResource(model);
                --this.indent;
                this.nl();
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
            }
            finally {
                if (this.writer != null) {
                    this.writer.flush();
                    if (outputStream != null) {
                        if (outputStream instanceof ZipOutputStream) {
                            ((ZipOutputStream)outputStream).closeEntry();
                        }
                        outputStream.close();
                    }
                    this.writer.close();
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    private void writeResource(IGmfModel model) throws XMLStreamException {
        this.nl();
        this.writer.writeStartElement("root");
        ++this.indent;
        IGmfComponent root = this.resolver.resolve(model.getRoot(), this.resource);
        this.writer.writeAttribute("id", String.valueOf(root.getId()));
        this.writer.writeAttribute("type", root.getType());
        this.writer.writeAttribute("domain", root.getDomain());
        this.writeComponent(root, false);
        --this.indent;
        this.nl();
        this.writer.writeEndElement();
    }

    void writeComponent(IGmfComponent component, boolean writeComponentTag) throws XMLStreamException {
        if (writeComponentTag) {
            this.nl();
            this.writer.writeStartElement(component.getType());
            this.writer.writeAttribute("id", String.valueOf(component.getId()));
            ++this.indent;
        }
        for (IGmfAttribute attr : component.getAttributes()) {
            this.writeAttribute(attr.getName(), attr.getValue());
        }
        for (IGmfList list : component.getLists()) {
            this.writeList(list, component);
        }
        for (IGmfElement element : component.getElements()) {
            this.writeElement(element, component);
        }
        if (writeComponentTag) {
            --this.indent;
            this.nl();
            this.writer.writeEndElement();
        }
    }

    private void writeList(IGmfList list, IGmfComponent component) throws XMLStreamException {
        IGmfComponent child;
        boolean valid = false;
        for (IGmfRef ref : list.getRef()) {
            child = this.resolver.resolve(ref, this.resource);
            if (child == null) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return;
        }
        this.nl();
        this.writer.writeStartElement(list.getName());
        if (list.getContained().booleanValue()) {
            ++this.indent;
            for (IGmfRef ref : list.getRef()) {
                child = this.resolver.resolve(ref, this.resource);
                if (child == null) continue;
                this.writeComponent(child, true);
            }
            --this.indent;
            this.nl();
        } else {
            StringBuffer buf = new StringBuffer();
            for (IGmfRef ref : list.getRef()) {
                IGmfComponent child2 = this.resolver.resolve(ref, this.resource);
                if (child2 == null) continue;
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(ref.giGetElementId());
            }
            this.writer.writeAttribute("reflist", "true");
            this.writer.writeCharacters(buf.toString());
        }
        this.writer.writeEndElement();
    }

    private void writeElement(IGmfElement element, IGmfComponent component) throws XMLStreamException {
        IGmfComponent child;
        boolean valid = false;
        IGmfRef ref = element.getRef();
        if (ref != null) {
            child = this.resolver.resolve(ref, this.resource);
            boolean bl = valid = child != null;
        }
        if (!valid) {
            return;
        }
        this.nl();
        this.writer.writeStartElement(element.getName());
        if (element.getContained().booleanValue()) {
            ++this.indent;
            child = this.resolver.resolve(ref, this.resource);
            String type = child.getType();
            this.writer.writeAttribute("id", String.valueOf(child.getId()));
            if (type != null && type.length() > 0) {
                this.writer.writeAttribute("type", type);
            }
            this.writeComponent(child, false);
            --this.indent;
            this.nl();
        } else {
            this.writer.writeAttribute("ref", "true");
            this.writer.writeCharacters("" + ref.giGetElementId());
        }
        this.writer.writeEndElement();
    }

    private void writeAttribute(String name, String value) throws XMLStreamException {
        this.nl();
        this.writer.writeStartElement(name);
        this.writer.writeCharacters(value);
        this.writer.writeEndElement();
    }

    private void writeMetaSection(IGmfModel model) throws XMLStreamException {
        for (IGmfMeta meta : model.getMeta()) {
            this.nl();
            this.writer.writeStartElement("meta");
            this.writer.writeAttribute(meta.getName(), meta.getValue());
            this.writer.writeEndElement();
        }
    }

    private void writeLibraries(IGmfModel model) throws XMLStreamException {
        this.nl();
        this.writer.writeStartElement("libraries");
        ++this.indent;
        for (IGmfLibrary lib : model.getLibrary()) {
            this.nl();
            this.writer.writeStartElement("library");
            ++this.indent;
            this.writeAttribute("name", lib.getName());
            this.writeAttribute("url", lib.getUrl());
            --this.indent;
            this.nl();
            this.writer.writeEndElement();
        }
        --this.indent;
        this.nl();
        this.writer.writeEndElement();
    }

    private void nl() throws XMLStreamException {
        this.writer.writeCharacters(FileUtil.lineSeparator());
        char[] chars = new char[this.indent];
        int i = 0;
        while (i < this.indent) {
            chars[i] = 32;
            ++i;
        }
        String s = new String(chars);
        this.writer.writeCharacters(s);
    }

    private OutputStream createZippedFileOutput(File file) throws IOException {
        return FileUtil.openZippedOutputStream((File)file, (String)"_model.xml");
    }
}

