/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.figaro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.edgemind.ibee.q.figaro.FigaroAttribute;
import net.edgemind.ibee.q.figaro.FigaroConstant;
import net.edgemind.ibee.q.figaro.FigaroElement;
import net.edgemind.ibee.q.figaro.FigaroInteraction;
import net.edgemind.ibee.q.figaro.FigaroInterface;
import net.edgemind.ibee.q.figaro.FigaroOccurrence;

public class FigaroObject
extends FigaroElement {
    private String name;
    private String type;
    private List<FigaroConstant> constants = new ArrayList<FigaroConstant>();
    private List<FigaroAttribute> attributes = new ArrayList<FigaroAttribute>();
    private List<FigaroInterface> interfaces = new ArrayList<FigaroInterface>();
    private List<FigaroInteraction> interactions = new ArrayList<FigaroInteraction>();
    private List<FigaroOccurrence> occurrences = new ArrayList<FigaroOccurrence>();

    public FigaroObject() {
    }

    public FigaroObject(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addAttribute(FigaroAttribute attribute) {
        this.attributes.add(attribute);
    }

    public List<FigaroAttribute> getAttributes() {
        return this.attributes;
    }

    public void addConstant(FigaroConstant constant) {
        this.constants.add(constant);
    }

    public List<FigaroConstant> getConstants() {
        return Collections.unmodifiableList(this.constants);
    }

    public void removeConstant(FigaroConstant constant) {
        this.constants.remove(constant);
    }

    public void addInterface(FigaroInterface iface) {
        this.interfaces.add(iface);
    }

    public void addOccurrence(FigaroOccurrence element) {
        this.occurrences.add(element);
    }

    public void addInteraction(FigaroInteraction element) {
        this.interactions.add(element);
    }

    public List<FigaroInterface> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public FigaroInterface getInterface(String name) {
        for (FigaroInterface iface : this.interfaces) {
            if (!iface.getName().equalsIgnoreCase(name)) continue;
            return iface;
        }
        return null;
    }

    public void removeInterface(FigaroInterface iface) {
        this.interfaces.remove(iface);
    }

    @Override
    public void writeln(int indent, StringBuffer buf) {
        this.append("OBJET " + this.name + " EST_UN " + this.type + ";", indent, buf);
        indent += 10;
        if (!this.interfaces.isEmpty()) {
            this.append("INTERFACE", indent, buf);
        }
        for (FigaroInterface figaroInterface : this.interfaces) {
            figaroInterface.writeln(indent + 3, buf);
        }
        if (!this.constants.isEmpty()) {
            this.append("CONSTANTE", indent, buf);
        }
        for (FigaroConstant figaroConstant : this.constants) {
            figaroConstant.writeln(indent + 3, buf);
        }
        if (!this.attributes.isEmpty()) {
            this.append("ATTRIBUT", indent, buf);
        }
        for (FigaroAttribute figaroAttribute : this.attributes) {
            figaroAttribute.writeln(indent + 3, buf);
        }
        if (!this.interactions.isEmpty()) {
            this.append("INTERACTION", indent, buf);
        }
        for (FigaroInteraction figaroInteraction : this.interactions) {
            figaroInteraction.writeln(indent + 3, buf);
        }
        if (!this.occurrences.isEmpty()) {
            this.append("OCCURRENCE", indent, buf);
        }
        for (FigaroOccurrence figaroOccurrence : this.occurrences) {
            figaroOccurrence.writeln(indent + 3, buf);
        }
    }
}

