/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.scram;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.io.StreamReader;
import net.edgemind.ibee.core.io.TaskHandler;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.q.exception.QuantificationException;

public class ScramLauncher {
    private String scramBinary = "scram";
    private TaskHandler logHandler;
    private String resultFile = "result.xml";
    private Process process;
    private Thread processThread;
    private boolean peformImportanceAnalysis = false;
    private boolean performUncertaintyAnalysis = false;

    public void setScramBinary(String file) {
        this.scramBinary = file;
    }

    public void setLogHandler(TaskHandler handler) {
        this.logHandler = handler;
    }

    public void setResultFile(String file) {
        this.resultFile = file;
    }

    public void performImportanceAnalysis(boolean value) {
        this.peformImportanceAnalysis = value;
    }

    public void performUncertaintyAnalysis(boolean value) {
        this.performUncertaintyAnalysis = value;
    }

    public void cancel() {
        if (this.process != null && this.process.isAlive()) {
            this.processThread.interrupt();
            this.process.destroyForcibly();
        }
    }

    public void launch(File configFile) throws IbeeException {
        if (this.scramBinary == null || this.scramBinary.length() == 0) {
            throw new IbeeException("Please configure scram executable");
        }
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(this.scramBinary, "--project", configFile.getAbsolutePath(), "--output", this.resultFile, "--ccf"));
        if (this.peformImportanceAnalysis) {
            cmd.add("--importance");
        }
        if (this.performUncertaintyAnalysis) {
            cmd.add("--uncertainty");
        }
        this.executeCmd(cmd);
    }

    public void launch(File modelFile, Map<String, String> options) throws IbeeException {
        if (this.scramBinary == null || this.scramBinary.length() == 0) {
            throw new IbeeException("Please configure scram executable");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.scramBinary);
        for (String option : options.keySet()) {
            cmd.add(option);
            String value = options.get(option);
            if (value == null) continue;
            cmd.add(value);
        }
        cmd.add(modelFile.getAbsolutePath());
        this.executeCmd(cmd);
    }

    private void executeCmd(List<String> cmd) {
        Object commandAsString = "";
        for (String n : cmd) {
            commandAsString = (String)commandAsString + n + " ";
        }
        this.logHandler.log((String)commandAsString, LogLevel.INFO);
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            this.processThread = Thread.currentThread();
            this.process = pb.start();
            StreamReader inputReader = null;
            StreamReader errorReader = null;
            try {
                ALogHandler handler = new ALogHandler(){

                    public void log(Throwable e) {
                        ScramLauncher.this.logHandler.log(e);
                    }

                    public void log(String msg, LogLevel level) {
                        ScramLauncher.this.logHandler.log(msg, level);
                    }

                    public String getName() {
                        return null;
                    }
                };
                inputReader = new StreamReader(this.process.getInputStream(), "UTF-8");
                inputReader.setHandler((ILogHandler)handler);
                inputReader.setLogLevel(LogLevel.INFO);
                inputReader.start();
                errorReader = new StreamReader(this.process.getErrorStream(), "UTF-8");
                errorReader.setHandler((ILogHandler)handler);
                errorReader.setLogLevel(LogLevel.ERROR);
                errorReader.start();
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    if (this.process.isAlive()) {
                        this.process.destroyForcibly();
                    }
                    if (inputReader.isAlive()) {
                        inputReader.interrupt();
                    }
                    if (errorReader.isAlive()) {
                        errorReader.interrupt();
                    }
                    throw new ManualInteruptionException("Quantification stopped");
                }
                inputReader.join();
                errorReader.join();
            }
            catch (InterruptedException interruptedException) {
                if (inputReader.isAlive()) {
                    inputReader.interrupt();
                }
                if (errorReader.isAlive()) {
                    errorReader.interrupt();
                }
                throw new ManualInteruptionException("Quantification stopped");
            }
        }
        catch (IOException e) {
            throw new QuantificationException(e);
        }
    }
}

