/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.scram;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamWriter;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScramResultConverter {
    ResultAdapter adapter;
    Document doc;
    XMLStreamWriter out;

    public void setAdapter(ResultAdapter resolver) {
        this.adapter = resolver;
    }

    public void convertScramResultFile(File in, File out) {
        try {
            this.doc = XmlUtil.readXmlFile((File)in);
            NodeList ns = this.doc.getChildNodes();
            int i = 0;
            while (i < ns.getLength()) {
                Node node = ns.item(i);
                if (node instanceof Element) {
                    Element child = (Element)ns.item(i);
                    this.adapt(child);
                }
                ++i;
            }
            XmlUtil.writeXmlFile((Document)this.doc, (String)out.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private void adapt(Element tag) {
        if (this.adapter.adapt(tag)) {
            this.adapter.doAdapt(tag);
        }
        NodeList ns = tag.getChildNodes();
        int i = 0;
        while (i < ns.getLength()) {
            Node node = ns.item(i);
            if (node instanceof Element) {
                Element child = (Element)ns.item(i);
                this.adapt(child);
            }
            ++i;
        }
    }

    public static interface ResultAdapter {
        public boolean adapt(Element var1);

        public void doAdapt(Element var1);
    }
}

