/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.scram;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.q.model.cutset.ICutset;
import net.edgemind.ibee.q.model.cutset.ICutsetDomain;
import net.edgemind.ibee.q.model.cutset.ICutsetResult;
import net.edgemind.ibee.q.model.cutset.IEvent;
import net.edgemind.ibee.q.model.cutset.IImportanceFactors;
import net.edgemind.ibee.q.model.cutset.ITopEventResult;
import net.edgemind.ibee.q.model.q.IQresult;
import net.edgemind.ibee.util.string.StringUtil;
import net.edgemind.ibee.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScramResultReader {
    private NameResolver nameResolver;
    private Map<String, IEvent> addedEvents = new HashMap<String, IEvent>();
    private String topEventName = null;
    private ICutsetResult result;
    private int maxCutsets = 10000;

    public void setNameResolver(NameResolver resolver) {
        this.nameResolver = resolver;
    }

    public void setMaxCutsets(int nr) {
        this.maxCutsets = nr;
    }

    public void setTopEventName(String name) {
        this.topEventName = name;
    }

    public void read(File resultFile, IQresult mainResult) throws IbeeException {
        this.addedEvents.clear();
        this.result = ICutsetDomain.instance.createCutsetResult();
        mainResult.addResult(this.result);
        this.readCutsets(resultFile);
        List events = this.result.giGetResource().getAllObjects(IEvent.type);
        if (this.nameResolver != null) {
            for (IElement event : events) {
                String eventName = ((IEvent)event).getName();
                eventName = this.nameResolver.resolve(eventName);
                ((IEvent)event).setName(eventName);
            }
        }
    }

    private void readCutsets(File file) {
        try {
            Document doc = XmlUtil.readXmlFile((File)file);
            Element elReport = doc.getDocumentElement();
            Element elInfo = XmlUtil.getFirstChildByTagName((String)"information", (Element)elReport);
            Element elResults = XmlUtil.getFirstChildByTagName((String)"results", (Element)elReport);
            if (elResults != null) {
                Element elImportance;
                Element elCutsets = XmlUtil.getFirstChildByTagName((String)"sum-of-products", (Element)elResults);
                if (elCutsets != null) {
                    ITopEventResult topResult = ICutsetDomain.instance.createTopEventResult();
                    this.result.setTopEvent(topResult);
                    topResult.setP(StringUtil.toDouble((String)elCutsets.getAttribute("probability"), (double)0.0));
                    if (this.topEventName != null) {
                        topResult.setName(this.topEventName);
                    } else {
                        topResult.setName(elCutsets.getAttribute("name"));
                    }
                    List lstProducts = XmlUtil.getChildrenByTagName((String)"product", (Element)elCutsets);
                    ArrayList<ICutset> csList = new ArrayList<ICutset>();
                    for (Element elProduct : lstProducts) {
                        List lstBes = XmlUtil.getChildrenByTagName((String)"basic-event", (Element)elProduct);
                        ICutset cutset = ICutsetDomain.instance.createCutset();
                        this.result.giGetResource().putObject((IElement)cutset);
                        csList.add(cutset);
                        cutset.setProbability(StringUtil.toDouble((String)elProduct.getAttribute("probability"), (double)0.0));
                        cutset.setContribution(StringUtil.toDouble((String)elProduct.getAttribute("contribution"), (double)0.0));
                        lstBes.sort(new Comparator<Element>(){

                            @Override
                            public int compare(Element o1, Element o2) {
                                return o1.getAttribute("name").compareToIgnoreCase(o2.getAttribute("name"));
                            }
                        });
                        Iterator iterator = lstBes.iterator();
                        while (iterator.hasNext()) {
                            Element elBe = (Element)iterator.next();
                            String name = elBe.getAttribute("name");
                            IEvent event = this.getEvent(name);
                            cutset.addEvent(event);
                        }
                        if (csList.size() >= this.maxCutsets) break;
                    }
                    csList.sort(new Comparator<IElement>(){

                        @Override
                        public int compare(IElement o1, IElement o2) {
                            if (((ICutset)o1).getProbability() < ((ICutset)o2).getProbability()) {
                                return 1;
                            }
                            if (((ICutset)o1).getProbability() > ((ICutset)o2).getProbability()) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    int rank = 1;
                    for (IElement iElement : csList) {
                        ((ICutset)iElement).setNumber(rank++);
                    }
                    this.result.giGetList(ICutsetResult.cutsetsFeature).addElements(csList);
                }
                if ((elImportance = XmlUtil.getFirstChildByTagName((String)"importance", (Element)elResults)) != null) {
                    List lstBes = XmlUtil.getChildrenByTagName((String)"basic-event", (Element)elImportance);
                    for (Element elBe : lstBes) {
                        String string = elBe.getAttribute("name");
                        IEvent event = this.getEvent(string);
                        IImportanceFactors ifactors = ICutsetDomain.instance.createImportanceFactors();
                        event.setImportanceFactor(ifactors);
                        ifactors.setOccurrences(StringUtil.toInt((String)elBe.getAttribute("occurrence"), (Integer)0));
                        ifactors.setP(StringUtil.toDouble((String)elBe.getAttribute("probability"), (double)0.0));
                        ifactors.setMif(StringUtil.toDouble((String)elBe.getAttribute("MIF"), (double)0.0));
                        ifactors.setCif(StringUtil.toDouble((String)elBe.getAttribute("CIF"), (double)0.0));
                        ifactors.setDif(StringUtil.toDouble((String)elBe.getAttribute("DIF"), (double)0.0));
                        ifactors.setRaw(StringUtil.toDouble((String)elBe.getAttribute("RAW"), (double)0.0));
                        ifactors.setRrw(StringUtil.toDouble((String)elBe.getAttribute("RRW"), (double)0.0));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private IEvent getEvent(String name) {
        if (this.addedEvents.containsKey(name)) {
            return this.addedEvents.get(name);
        }
        IEvent event = ICutsetDomain.instance.createEvent();
        event.setName(name);
        this.addedEvents.put(name, event);
        this.result.addEvent(event);
        return event;
    }

    public static interface NameResolver {
        public String resolve(String var1);
    }
}

