/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.scram;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.transform.TransformerFactoryConfigurationError;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.q.model.cutset.ICutset;
import net.edgemind.ibee.q.model.cutset.ICutsetDomain;
import net.edgemind.ibee.q.model.cutset.ICutsetResult;
import net.edgemind.ibee.q.model.cutset.IEvent;
import net.edgemind.ibee.q.model.cutset.IImportanceFactors;
import net.edgemind.ibee.q.model.cutset.ITopEventResult;
import net.edgemind.ibee.q.model.q.IQresult;
import net.edgemind.ibee.util.string.StringUtil;
import org.w3c.dom.DOMException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ScramResultReader2 {
    private NameResolver nameResolver;
    private Map<String, IEvent> addedEvents = new HashMap<String, IEvent>();
    private String topEventName = null;
    private ICutsetResult result;
    private Function<CcfEventGroup, String> ccfGroupNameEncoder;
    private CcfEventGroup currentCcfGroup;
    IImportanceFactors currentImportanceFactors;
    private int maxCutsets = 10000;
    private Stack<Tag> tags = new Stack();
    private ICutset cutset;
    private List<ICutset> csList;

    public Function<CcfEventGroup, String> getCcfGroupNameEncoder() {
        return this.ccfGroupNameEncoder;
    }

    public void setCcfGroupNameEncoder(Function<CcfEventGroup, String> ccfGroupNameEncoder) {
        this.ccfGroupNameEncoder = ccfGroupNameEncoder;
    }

    public void setNameResolver(NameResolver resolver) {
        this.nameResolver = resolver;
    }

    public void setMaxCutsets(int nr) {
        this.maxCutsets = nr;
    }

    public void setTopEventName(String name) {
        this.topEventName = name;
    }

    public void read(File resultFile, IQresult mainResult) throws IbeeException {
        try {
            mainResult.giGetResource().disableNotifications();
            this.addedEvents.clear();
            this.result = ICutsetDomain.instance.createCutsetResult();
            mainResult.addResult(this.result);
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(resultFile, (DefaultHandler)new MyXMLHandler());
                this.result.giGetList(ICutsetResult.cutsetsFeature).addElements(this.csList);
            }
            catch (DOMException e) {
                throw new IbeeException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new IbeeException((Throwable)e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new IbeeException((Throwable)e);
            }
            catch (SAXException e) {
                throw new IbeeException((Throwable)e);
            }
            catch (IOException e) {
                throw new IbeeException((Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                throw new IbeeException((Throwable)e);
            }
        }
        finally {
            mainResult.giGetResource().enableNotifications();
        }
    }

    private IEvent resolveBasicEvent(String name) {
        name = this.nameResolver.resolve(name, ElType.BE);
        return this.getEvent(name);
    }

    private IEvent resolveCcfEvent(CcfEventGroup ccfGroup) {
        String name = this.ccfGroupNameEncoder.apply(ccfGroup);
        return this.getEvent(name);
    }

    private IEvent getEvent(String name) {
        if (this.addedEvents.containsKey(name)) {
            return this.addedEvents.get(name);
        }
        IEvent event = ICutsetDomain.instance.createEvent();
        event.setName(name);
        this.addedEvents.put(name, event);
        this.result.addEvent(event);
        return event;
    }

    public static class CcfEventGroup {
        private String ccfName;
        private HashSet<String> ccfEvents = new HashSet();

        public CcfEventGroup(String ccfName) {
            this.ccfName = ccfName;
        }

        public String getName() {
            return this.ccfName;
        }

        public void addEvent(String event) {
            this.ccfEvents.add(event);
        }

        public Set<String> getEvents() {
            return this.ccfEvents;
        }
    }

    public static enum ElType {
        BE,
        CCF;

    }

    public class MyXMLHandler
    extends DefaultHandler {
        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        public int insert(double p, int start, int end) {
            if (start == end) {
                return start;
            }
            int middle = (start + end - 1) / 2;
            ICutset cs = ScramResultReader2.this.csList.get(middle);
            if (p > cs.getProbability()) {
                return this.insert(p, start, middle);
            }
            return this.insert(p, middle + 1, end);
        }

        private boolean within(String ... path) {
            int index = path.length - 1;
            while (index >= 0) {
                String arg = path[index];
                int tagIndex = ScramResultReader2.this.tags.size() - (path.length - index);
                if (tagIndex < 0 || tagIndex >= ScramResultReader2.this.tags.size()) {
                    return false;
                }
                Tag tag = (Tag)ScramResultReader2.this.tags.get(tagIndex);
                if (!tag.name.equals(arg)) {
                    return false;
                }
                --index;
            }
            return true;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Tag tag = new Tag();
            tag.name = qName;
            ScramResultReader2.this.tags.add(tag);
            if (this.within("results", "sum-of-products")) {
                String productName = attributes.getValue("name");
                if (productName.equals(ScramResultReader2.this.topEventName)) {
                    ScramResultReader2.this.csList = new ArrayList<ICutset>();
                    ITopEventResult topResult = ICutsetDomain.instance.createTopEventResult();
                    ScramResultReader2.this.result.setTopEvent(topResult);
                    topResult.setP(StringUtil.toDouble((String)attributes.getValue("probability"), (double)0.0));
                    if (ScramResultReader2.this.topEventName != null) {
                        topResult.setName(ScramResultReader2.this.topEventName);
                    } else {
                        topResult.setName(attributes.getValue("name"));
                    }
                }
            } else if (this.within("results", "sum-of-products", "product")) {
                if (ScramResultReader2.this.csList == null) {
                    return;
                }
                double p = StringUtil.toDouble((String)attributes.getValue("probability"), (double)0.0);
                int index = this.insert(p, 0, ScramResultReader2.this.csList.size());
                if (ScramResultReader2.this.maxCutsets > 0 && index >= ScramResultReader2.this.maxCutsets) {
                    ScramResultReader2.this.cutset = null;
                    return;
                }
                if (ScramResultReader2.this.maxCutsets > 0 && ScramResultReader2.this.csList.size() == ScramResultReader2.this.maxCutsets) {
                    ScramResultReader2.this.cutset = ScramResultReader2.this.csList.remove(ScramResultReader2.this.maxCutsets - 1);
                    ScramResultReader2.this.cutset.clear();
                } else {
                    ScramResultReader2.this.cutset = ICutsetDomain.instance.createCutset();
                    ScramResultReader2.this.result.giGetResource().putObject((IElement)ScramResultReader2.this.cutset);
                }
                ScramResultReader2.this.csList.add(index, ScramResultReader2.this.cutset);
                ScramResultReader2.this.cutset.setProbability(p);
                ScramResultReader2.this.cutset.setContribution(StringUtil.toDouble((String)attributes.getValue("contribution"), (double)0.0));
            } else if (this.within("results", "sum-of-products", "product", "basic-event")) {
                if (ScramResultReader2.this.cutset == null) {
                    return;
                }
                String name = attributes.getValue("name");
                IEvent event = ScramResultReader2.this.resolveBasicEvent(name);
                ScramResultReader2.this.cutset.addEvent(event);
            } else if (this.within("results", "sum-of-products", "product", "ccf-event")) {
                String ccfName = attributes.getValue("ccf-group");
                ccfName = ScramResultReader2.this.nameResolver.resolve(ccfName, ElType.CCF);
                ScramResultReader2.this.currentCcfGroup = new CcfEventGroup(ccfName);
            } else if (this.within("results", "sum-of-products", "product", "ccf-event", "basic-event")) {
                String eventName = attributes.getValue("name");
                eventName = ScramResultReader2.this.nameResolver.resolve(eventName, ElType.BE);
                ScramResultReader2.this.currentCcfGroup.addEvent(eventName);
            } else if (this.within("results", "importance", "basic-event")) {
                String name = attributes.getValue("name");
                IEvent event = ScramResultReader2.this.resolveBasicEvent(name);
                event.setImportanceFactor(this.createImportanceFactors(attributes));
            } else if (this.within("results", "importance", "ccf-event")) {
                String ccfName = attributes.getValue("ccf-group");
                ccfName = ScramResultReader2.this.nameResolver.resolve(ccfName, ElType.CCF);
                ScramResultReader2.this.currentCcfGroup = new CcfEventGroup(ccfName);
                ScramResultReader2.this.currentImportanceFactors = this.createImportanceFactors(attributes);
            } else if (this.within("results", "importance", "ccf-event", "basic-event")) {
                String eventName = attributes.getValue("name");
                eventName = ScramResultReader2.this.nameResolver.resolve(eventName, ElType.BE);
                ScramResultReader2.this.currentCcfGroup.addEvent(eventName);
            } else if (this.within("results", "measure")) {
                String name = attributes.getValue("name");
                IEvent event = ScramResultReader2.this.resolveBasicEvent(name);
                event.getSensitivityFactors();
            }
        }

        private IImportanceFactors createImportanceFactors(Attributes attributes) {
            IImportanceFactors ifactors = ICutsetDomain.instance.createImportanceFactors();
            ifactors.setOccurrences(StringUtil.toInt((String)attributes.getValue("occurrence"), (Integer)0));
            ifactors.setP(StringUtil.toDouble((String)attributes.getValue("probability"), (double)0.0));
            ifactors.setMif(StringUtil.toDouble((String)attributes.getValue("MIF"), (double)0.0));
            ifactors.setCif(StringUtil.toDouble((String)attributes.getValue("CIF"), (double)0.0));
            ifactors.setDif(StringUtil.toDouble((String)attributes.getValue("DIF"), (double)0.0));
            ifactors.setRaw(StringUtil.toDouble((String)attributes.getValue("RAW"), (double)0.0));
            ifactors.setRrw(StringUtil.toDouble((String)attributes.getValue("RRW"), (double)0.0));
            return ifactors;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.within("results", "sum-of-products")) {
                if (ScramResultReader2.this.csList != null) {
                    int i = 1;
                    for (IElement iElement : ScramResultReader2.this.csList) {
                        ((ICutset)iElement).setNumber(i);
                        ++i;
                    }
                    ScramResultReader2.this.result.giGetList(ICutsetResult.minimalcutsetsFeature).addElements(ScramResultReader2.this.csList);
                    ScramResultReader2.this.csList = null;
                }
            } else if (this.within("results", "sum-of-products", "product", "ccf-event")) {
                if (ScramResultReader2.this.cutset != null) {
                    IEvent event = ScramResultReader2.this.resolveCcfEvent(ScramResultReader2.this.currentCcfGroup);
                    ScramResultReader2.this.cutset.addEvent(event);
                }
            } else if (this.within("results", "importance", "ccf-event")) {
                IEvent event = ScramResultReader2.this.resolveCcfEvent(ScramResultReader2.this.currentCcfGroup);
                if (ScramResultReader2.this.currentImportanceFactors != null) {
                    event.setImportanceFactor(ScramResultReader2.this.currentImportanceFactors);
                }
            }
            ScramResultReader2.this.tags.pop();
        }
    }

    public static interface NameResolver {
        public String resolve(String var1, ElType var2);
    }

    private class Tag {
        String name;

        private Tag() {
        }
    }
}

