/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.ui;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Node;
import net.edgemind.ibee.core.iml.model.IElement;
import net.edgemind.ibee.q.model.yams.IIndicator;
import net.edgemind.ibee.q.model.yams.IMeasurement;
import net.edgemind.ibee.q.model.yams.ISequence;
import net.edgemind.ibee.ui.charts.Chart;
import net.edgemind.ibee.ui.charts.LineChart;
import net.edgemind.ibee.ui.charts.XYChartElement;
import net.edgemind.ibee.ui.charts.axis.Axis;
import net.edgemind.ibee.ui.charts.formatter.IChartFormatter;
import net.edgemind.ibee.ui.charts.formatter.TransientColorFormatter;
import net.edgemind.ibee.ui.charts.viewer.ChartViewer;
import net.edgemind.ibee.ui.common.listener.IMouseDownListener;
import net.edgemind.ibee.ui.common.listener.IMouseMoveListener;
import net.edgemind.ibee.ui.diagram.CURSOR;
import net.edgemind.ibee.ui.diagram.DiagramPanel;
import net.edgemind.ibee.ui.diagram.DiagramUtil;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.viewer.IDiagramViewer;
import net.edgemind.ibee.ui.diagram.viewer.SelectionViewer;

public class IndicatorPanel<T> {
    private ChartViewer resultViewerHazard;
    private List<ISelectionListener> listeners;
    private IIndicator indicator;
    private String title;
    DiagramPanel diagramPanel;

    public void createHazardResultViewer(DiagramPanel panel) {
        SelectionViewer viewer = new SelectionViewer(panel);
        this.resultViewerHazard = new ChartViewer((IDiagramViewer)viewer);
        this.resultViewerHazard.setOverlayColor(Color.EMORANGE);
        viewer.getDiagramPanel().setHorizontalScrollbarEnabled(true);
        viewer.getDiagramPanel().setVerticalScrollbarEnabled(true);
        viewer.canZoomHorizontal(true);
        viewer.canZoomVertical(true);
        viewer.canTranslateHorizontal(true);
        viewer.canTranslateVertical(true);
        viewer.setMargin(10, 10);
        this.resultViewerHazard.create();
        this.diagramPanel = viewer.getDiagramPanel();
        this.diagramPanel.addMouseDownListener(new IMouseDownListener(){

            public void mouseDown(double x, double y, MouseButton btn) {
                Node node = DiagramUtil.getSelectedNode((Diagram)IndicatorPanel.this.diagramPanel.getDiagram(), (DiagramUtil.Coord)IndicatorPanel.this.createCoord(x, y), (double)IndicatorPanel.this.diagramPanel.getZoomX(), (double)IndicatorPanel.this.diagramPanel.getZoomY());
            }
        });
        this.diagramPanel.addMouseMoveListener(new IMouseMoveListener(){

            public void mouseMove(double x, double y) {
                Object event;
                boolean selectable = false;
                Node node = DiagramUtil.getSelectedNode((Diagram)IndicatorPanel.this.diagramPanel.getDiagram(), (DiagramUtil.Coord)IndicatorPanel.this.createCoord(x, y), (double)IndicatorPanel.this.diagramPanel.getZoomX(), (double)IndicatorPanel.this.diagramPanel.getZoomY());
                if (node != null && (event = node.getElement()) != null) {
                    selectable = true;
                }
                if (selectable) {
                    IndicatorPanel.this.diagramPanel.setCursor(CURSOR.HAND);
                } else {
                    IndicatorPanel.this.diagramPanel.setCursor(CURSOR.DEFAULT);
                }
            }
        });
    }

    protected DiagramUtil.Coord createCoord(double screenX, double screenY) {
        DiagramUtil.Coord coord = new DiagramUtil.Coord();
        coord.diagramX = this.diagramPanel.translateX(screenX);
        coord.diagramY = this.diagramPanel.translateY(screenY);
        coord.screenX = screenX;
        coord.screenY = screenY;
        return coord;
    }

    public void refresh() {
        boolean valid = false;
        if (this.indicator != null) {
            this.showHazardResult(this.indicator);
            valid = true;
        }
        if (!valid) {
            this.resultViewerHazard.viewChart(null);
        }
    }

    private void showHazardResult(IIndicator indicator) {
        LineChart chart = new LineChart();
        chart.setVertical(false);
        Axis xAxis = chart.createXAxis();
        xAxis.setUnit("");
        xAxis.getAxisFormatter().setNumberOfTicks(10);
        xAxis.setLabel("Time t (in t.u.)");
        Axis yAxis = chart.createYAxis();
        yAxis.setUnit("%");
        yAxis.getAxisFormatter().setNumberOfTicks(10);
        yAxis.setLabel("Probability (in %)");
        chart.setLineColor(Color.EMBLUE);
        chart.setBlobColor(Color.EMBLUE);
        chart.setConnectPoints(true);
        chart.setShowArrows(false);
        chart.setTitle(this.title);
        chart.setFormatter((IChartFormatter)new TransientColorFormatter(10.0, 50.0, 0.0, 100.0));
        if (indicator != null) {
            for (IMeasurement measurement : indicator.getMeasurements()) {
                double p = measurement.getProbability() + 0.0;
                int timepoint = measurement.getTimestamp() + 0;
                XYChartElement chartElement = new XYChartElement("" + timepoint, (double)timepoint, p * 100.0, (IElement)measurement);
                chart.addElement(chartElement);
            }
        }
        this.resultViewerHazard.viewChart((Chart)chart);
    }

    public synchronized void addSelectionListener(ISelectionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ISelectionListener>();
        }
        this.listeners.add(listener);
    }

    public synchronized void setIndicator(IIndicator indicator) {
        this.indicator = indicator;
    }

    public IIndicator getIndicator() {
        return this.indicator;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public static interface ISelectionListener {
        public void clicked(ISequence var1);
    }
}

