/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.xfta;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.core.io.StreamReader;
import net.edgemind.ibee.core.io.TaskHandler;
import net.edgemind.ibee.core.log.ALogHandler;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.q.exception.QuantificationException;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.string.StringUtil;

public class XftaLauncher {
    private String xftaBinary = "xfta";
    private TaskHandler logHandler;
    private Process process;
    private Thread processThread;
    private long timeout = 0L;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setXftaBinary(String file) {
        this.xftaBinary = file;
    }

    public void setLogHandler(TaskHandler handler) {
        this.logHandler = handler;
    }

    public void cancel() {
        if (this.process != null && this.process.isAlive()) {
            this.processThread.interrupt();
            this.process.destroyForcibly();
        }
    }

    public void launch(String configFile) throws IbeeException {
        if (this.xftaBinary == null || this.xftaBinary.length() == 0) {
            throw new IbeeException("Please configure xfta executable");
        }
        if (!FileUtil.fileExists((String)this.xftaBinary)) {
            throw new IbeeException("File " + this.xftaBinary + " not found. Please configure xfta correctly");
        }
        String[] cmd = new String[]{this.xftaBinary, configFile};
        Object s = "";
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            s = (String)s + n3 + " ";
            ++n2;
        }
        this.logHandler.log((String)s, LogLevel.INFO);
        try {
            ProcessBuilder pb = new ProcessBuilder(cmd);
            this.processThread = Thread.currentThread();
            this.process = pb.start();
            StreamReader inputReader = null;
            StreamReader errorReader = null;
            try {
                ALogHandler handler = new ALogHandler(){

                    public void log(Throwable e) {
                        XftaLauncher.this.logHandler.log(e);
                    }

                    public void log(String msg, LogLevel level) {
                        if (msg.contains("Calcul en cours")) {
                            int i3;
                            int i1 = msg.indexOf("Calcul en cours");
                            int i2 = msg.indexOf("%", i1);
                            if (i2 != -1 && (i3 = msg.lastIndexOf(" ", i2)) != -1) {
                                double progress = StringUtil.toDouble((String)msg.substring(i3, i2).trim(), (double)0.0);
                                XftaLauncher.this.logHandler.setProgress(progress);
                            }
                            return;
                        }
                        XftaLauncher.this.logHandler.log(msg, level);
                    }

                    public String getName() {
                        return null;
                    }
                };
                inputReader = new StreamReader(this.process.getInputStream(), "UTF-8");
                inputReader.setHandler((ILogHandler)handler);
                inputReader.setLogLevel(LogLevel.INFO);
                inputReader.start();
                errorReader = new StreamReader(this.process.getErrorStream(), "UTF-8");
                errorReader.setHandler((ILogHandler)handler);
                errorReader.setLogLevel(LogLevel.ERROR);
                errorReader.start();
                try {
                    if (this.timeout > 0L) {
                        boolean exited = this.process.waitFor(this.timeout, TimeUnit.SECONDS);
                        if (!exited) {
                            throw new InterruptedException("XFTA Timeout");
                        }
                    } else {
                        this.process.waitFor();
                    }
                }
                catch (InterruptedException e) {
                    if (this.process.isAlive()) {
                        this.process.destroyForcibly();
                    }
                    if (inputReader.isAlive()) {
                        inputReader.interrupt();
                    }
                    if (errorReader.isAlive()) {
                        errorReader.interrupt();
                    }
                    throw new ManualInteruptionException(e.getMessage());
                }
                inputReader.join();
                errorReader.join();
            }
            catch (InterruptedException interruptedException) {
                if (inputReader.isAlive()) {
                    inputReader.interrupt();
                }
                if (errorReader.isAlive()) {
                    errorReader.interrupt();
                }
                throw new ManualInteruptionException("XFTA engine cancelled by user");
            }
        }
        catch (IOException e) {
            throw new QuantificationException(e);
        }
    }
}

