/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.xfta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.log.ALogable;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.q.model.cutset.IBin;
import net.edgemind.ibee.q.model.cutset.ICutset;
import net.edgemind.ibee.q.model.cutset.ICutsetDomain;
import net.edgemind.ibee.q.model.cutset.ICutsetResult;
import net.edgemind.ibee.q.model.cutset.IEvent;
import net.edgemind.ibee.q.model.cutset.IImportanceFactors;
import net.edgemind.ibee.q.model.cutset.ISensitivityFactors;
import net.edgemind.ibee.q.model.cutset.ISensitivityHistogram;
import net.edgemind.ibee.q.model.cutset.ISensitivityResult;
import net.edgemind.ibee.q.model.cutset.ITopEventResult;
import net.edgemind.ibee.q.model.q.IQresult;
import net.edgemind.ibee.q.xfta.CsEvent;
import net.edgemind.ibee.q.xfta.Cutset;
import net.edgemind.ibee.q.xfta.CutsetList;
import net.edgemind.ibee.q.xfta.XftaConfigfileCreator;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.string.StringUtil;

public class XftaResultReader
extends ALogable {
    private NameResolver nameResolver;
    private Map<String, IEvent> addedEvents = new HashMap<String, IEvent>();
    private int maxNrCutsets = -1;
    private boolean readImportanceFactorResults = true;
    private boolean readUncertaintyResults = false;
    private ICutsetResult result;
    private boolean skipP0Cutsets = true;

    public void setMaxNrCutsets(int maxNrCutsets) {
        this.maxNrCutsets = maxNrCutsets;
    }

    public void setNameResolver(NameResolver resolver) {
        this.nameResolver = resolver;
    }

    public boolean getReadImportanceFactorResults() {
        return this.readImportanceFactorResults;
    }

    public void setReadImportanceFactorResults(boolean readImportanceFactorResults) {
        this.readImportanceFactorResults = readImportanceFactorResults;
    }

    public boolean getReadUncertaintyResults() {
        return this.readUncertaintyResults;
    }

    public void setReadUncertaintyResults(boolean readUncertaintyResults) {
        this.readUncertaintyResults = readUncertaintyResults;
    }

    public void setSkipP0Cutsets(boolean value) {
        this.skipP0Cutsets = value;
    }

    public ICutsetResult read(File resultFile, IQresult mainResult) throws IbeeException {
        String resultFilePath = resultFile.getAbsolutePath();
        try {
            mainResult.giGetResource().disableNotifications();
            this.addedEvents.clear();
            this.result = ICutsetDomain.instance.createCutsetResult();
            mainResult.addResult(this.result);
            this.readCutsets(resultFile);
            File importanceFactorResultFile = new File(XftaConfigfileCreator.getImportanceFactorResultFile(resultFilePath));
            this.readImportanceFactors(importanceFactorResultFile);
            if (this.readUncertaintyResults) {
                File sensitivityFactorResultFile = new File(XftaConfigfileCreator.getSensitivityResultFile(resultFilePath));
                this.readSensitivityFactors(sensitivityFactorResultFile);
                this.readHistogram(sensitivityFactorResultFile);
            }
            this.readProbability(new File(XftaConfigfileCreator.getPrResultFile(resultFilePath)));
            ICutsetResult iCutsetResult = this.result;
            return iCutsetResult;
        }
        finally {
            mainResult.giGetResource().enableNotifications();
        }
    }

    private String getCCFEventName(String eventName) {
        int index = eventName.lastIndexOf("-");
        return eventName.substring(0, index);
    }

    private String getCCFEventPostfix(String eventName) {
        int index = eventName.lastIndexOf("-");
        return eventName.substring(index);
    }

    private boolean isCCFEvent(String eventName) {
        return eventName.matches(".*-\\d+");
    }

    private void readCutsets(File resultFile) throws IbeeException {
        CutsetList cutsets;
        if (resultFile == null || !resultFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream in = FileUtil.openInputStream((File)resultFile, (boolean)false);){
                cutsets = this.read(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
        this.createImfCutsets(cutsets, this.result);
    }

    public CutsetList read(InputStream mcsStream) throws IbeeException {
        CutsetList cutsets = new CutsetList();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = FileUtil.openReader((InputStream)mcsStream, (Charset)Charset.defaultCharset());){
                int nrCutsetWithP0 = 0;
                while (reader.ready()) {
                    String[] args;
                    String line = reader.readLine().trim();
                    if (line.equals("") || (args = line.split("\\t+")).length < 3 || args.length > 0 && StringUtil.toDouble((String)args[0], null) == null) continue;
                    double p = StringUtil.toDouble((String)args[1], (double)0.0);
                    double c = StringUtil.toDouble((String)args[2], (double)0.0);
                    if (p == 0.0 && this.skipP0Cutsets) {
                        ++nrCutsetWithP0;
                        continue;
                    }
                    Cutset cutset = new Cutset();
                    cutsets.add(cutset);
                    cutset.setProbability(p);
                    cutset.setContribution(c);
                    int index = 3;
                    while (index < args.length) {
                        String eventName = args[index];
                        eventName = this.normalize(eventName);
                        eventName = this.correctEventName(eventName);
                        CsEvent csEvent = new CsEvent(eventName);
                        cutset.add(csEvent);
                        ++index;
                    }
                    if (this.maxNrCutsets > 0 && cutsets.getCutsets().size() == this.maxNrCutsets) break;
                }
                if (nrCutsetWithP0 > 0) {
                    this.warn(String.format("XFTA cutset result contains %d cutsets with probability = 0.0 discarded by Andromeda.", nrCutsetWithP0));
                }
                return cutsets;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            throw new IbeeException((Throwable)e);
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    public String correctEventName(String eventName) {
        if (this.nameResolver != null) {
            String ccfEventPostfix = "";
            if (this.isCCFEvent((String)eventName)) {
                ccfEventPostfix = this.getCCFEventPostfix((String)eventName);
                eventName = this.getCCFEventName((String)eventName);
            }
            eventName = this.nameResolver.resolve((String)eventName) + ccfEventPostfix;
        }
        return eventName;
    }

    private void createImfCutsets(CutsetList csList, ICutsetResult result) {
        int nr = 1;
        for (Cutset cs : csList.getCutsets()) {
            ICutset cutset = ICutsetDomain.instance.createCutset();
            result.addMinimalCutset(cutset);
            cutset.setProbability(cs.getProability());
            cutset.setContribution(cs.getContribution());
            cutset.setNumber(nr++);
            for (CsEvent csEvent : cs.getEvents()) {
                String name = csEvent.getName();
                IEvent event = this.getEvent(name);
                cutset.addEvent(event);
            }
        }
    }

    private void readImportanceFactors(File resultFile) throws IbeeException {
        if (resultFile == null || !resultFile.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(resultFile));){
                boolean ifMode = false;
                int fileFormat = 0;
                int maxArguments = 0;
                while (reader.ready()) {
                    String[] args;
                    String line = reader.readLine().trim();
                    if (line.equals("")) continue;
                    if (line.contains("MIF") && line.replaceAll("\\s", "").equals("basic-eventoccurrencesPrMIFCIFDIFRAWRRW")) {
                        ifMode = true;
                        fileFormat = 1;
                        maxArguments = 8;
                        continue;
                    }
                    if (line.contains("MIF") && line.replaceAll("\\s", "").equals("variablePrMIFCIFDIFRAWRRW")) {
                        ifMode = true;
                        fileFormat = 2;
                        maxArguments = 7;
                        continue;
                    }
                    if (!ifMode || (args = line.split("\\t+")).length < maxArguments) continue;
                    if (args.length > 8) {
                        System.out.println("error");
                    }
                    int l = args.length;
                    String eventName = this.extractName(args, l - (maxArguments - 1));
                    eventName = this.correctEventName(eventName);
                    IEvent event = this.getEvent(eventName);
                    double p = StringUtil.toDouble((String)args[l - 6], (double)0.0);
                    double mif = StringUtil.toDouble((String)args[l - 5], (double)0.0);
                    double cif = StringUtil.toDouble((String)args[l - 4], (double)0.0);
                    double dif = StringUtil.toDouble((String)args[l - 3], (double)0.0);
                    double raw = StringUtil.toDouble((String)args[l - 2], (double)0.0);
                    double rrw = StringUtil.toDouble((String)args[l - 1], (double)0.0);
                    IImportanceFactors importanceFactors = ICutsetDomain.instance.createImportanceFactors();
                    event.setImportanceFactor(importanceFactors);
                    importanceFactors.setP(p);
                    importanceFactors.setMif(mif);
                    importanceFactors.setCif(cif);
                    importanceFactors.setDif(dif);
                    importanceFactors.setRaw(raw);
                    importanceFactors.setRrw(rrw);
                    if (fileFormat != 1) continue;
                    int occurrences = StringUtil.toInt((String)args[l - 7], (Integer)0);
                    importanceFactors.setOccurrences(occurrences);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            LogUtil.log((Throwable)e);
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private String extractName(String[] args, int l) {
        if (l == 1) {
            return this.normalize(args[0]);
        }
        StringBuffer buf = new StringBuffer();
        boolean first = false;
        int i = 0;
        while (i < l) {
            if (first) {
                first = false;
            } else {
                buf.append(" ");
            }
            buf.append(args[i]);
            ++i;
        }
        return this.normalize(buf.toString());
    }

    private String normalize(String s) {
        return s.replaceAll("&amp;", "&");
    }

    private void readSensitivityFactors(File file) throws IbeeException {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                boolean ifMode = false;
                while (reader.ready()) {
                    String[] args;
                    String line = reader.readLine().trim();
                    if (line.equals("")) continue;
                    if (line.replaceAll("\\s", "").equals("basic-eventmeanstandard-deviationconfidence-rangeerror-factor")) {
                        ifMode = true;
                        continue;
                    }
                    if (line.replaceAll("\\s", "").equals("top-eventmeanstandard-deviationconfidence-rangeerror-factor")) {
                        ifMode = true;
                        continue;
                    }
                    if (line.endsWith("meanstandard-deviationconfidence-rangeerror-factor")) {
                        ifMode = false;
                    }
                    if (!ifMode || (args = line.split("\\t+")).length < 6) continue;
                    if (args.length > 6) {
                        System.out.println("error");
                    }
                    int l = args.length;
                    String eventName = this.extractName(args, l - 5);
                    eventName = this.correctEventName(eventName);
                    IEvent event = this.getEvent(eventName);
                    double mean = StringUtil.toDouble((String)args[l - 5], (double)0.0);
                    double var = StringUtil.toDouble((String)args[l - 4], (double)0.0);
                    double confidence1 = StringUtil.toDouble((String)args[l - 3], (double)0.0);
                    double confidence2 = StringUtil.toDouble((String)args[l - 2], (double)0.0);
                    double errFactor = StringUtil.toDouble((String)args[l - 1], (double)0.0);
                    ISensitivityFactors sensFactors = ICutsetDomain.instance.createSensitivityFactors();
                    event.setSensitivityFactor(sensFactors);
                    sensFactors.setMean(mean);
                    sensFactors.setVariance(var);
                    sensFactors.setConfidence1(confidence1);
                    sensFactors.setConfidence2(confidence2);
                    sensFactors.setErrorFactor(errFactor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            LogUtil.log((Throwable)e);
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private void readHistogram(File resultFile) throws IbeeException {
        if (resultFile == null || !resultFile.exists()) {
            return;
        }
        ISensitivityResult sensitivityResult = ICutsetDomain.instance.createSensitivityResult();
        this.result.setSensitivityResult(sensitivityResult);
        ISensitivityHistogram histogram = ICutsetDomain.instance.createSensitivityHistogram();
        sensitivityResult.setSensitivityHistogram(histogram);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(resultFile));){
                boolean ifMode = false;
                while (reader.ready()) {
                    String[] args;
                    String line = reader.readLine().trim();
                    if (line.equals("")) continue;
                    if (line.replaceAll("\\s", "").equals("binvalue")) {
                        ifMode = true;
                        continue;
                    }
                    if (!ifMode || (args = line.split("\\t+")).length < 2) continue;
                    IBin bin = ICutsetDomain.instance.createBin();
                    bin.setValue(StringUtil.toDouble((String)args[1], (double)0.0));
                    histogram.addBin(bin);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            LogUtil.log((Throwable)e);
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private void readProbability(File resultFile) throws IbeeException {
        if (resultFile == null || !resultFile.exists()) {
            return;
        }
        ITopEventResult topEventResult = ICutsetDomain.instance.createTopEventResult();
        this.result.setTopEvent(topEventResult);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(resultFile));){
                boolean ifMode = false;
                while (reader.ready()) {
                    String[] args;
                    String line = reader.readLine().trim();
                    if (line.equals("")) continue;
                    if (line.replaceAll("\\s", "").equals("timeQ")) {
                        ifMode = true;
                        continue;
                    }
                    if (!ifMode || (args = line.split("\\t+")).length < 2) continue;
                    if (args.length > 2) {
                        System.out.println("error");
                    }
                    double p = StringUtil.toDouble((String)args[1], (double)0.0);
                    topEventResult.setName("top");
                    topEventResult.setP(p);
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            LogUtil.log((Throwable)e);
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private IEvent getEvent(String name) {
        if (this.addedEvents.containsKey(name)) {
            return this.addedEvents.get(name);
        }
        IEvent event = ICutsetDomain.instance.createEvent();
        event.setName(name);
        this.addedEvents.put(name, event);
        this.result.addEvent(event);
        return event;
    }

    public static interface NameResolver {
        public String resolve(String var1);
    }
}

