/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.q.xfta2;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.edgemind.ibee.core.exception.IbeeException;

public class XftaScriptCreator {
    private StringBuffer buf;
    private double minProbability = 0.0;
    private int maxOrder = 0;
    private int maxNrOfCutsets = 1000000;
    private String mcsResultFile = "mcs.txt";
    private String topEventResultFile = "pr.txt";
    private String impResultFile = "imp.txt";
    private String sensResultFile = "sens.txt";
    private String mftFile = "mft.xml";
    private boolean printMinimalCutsets = true;
    private boolean computeTopEventProbability = true;
    private boolean computeImportanceFactors = true;
    private boolean computeUncertainty = false;
    private MftInputFormat mftFormat = MftInputFormat.OPENPSA;
    private String topEventName = "top";
    private int nrOfUncertaintySimulations = 0;
    private double missionTime = 24.0;

    public int getNrOfUncertaintySimulations() {
        return this.nrOfUncertaintySimulations;
    }

    public void setNrOfUncertaintySimulations(int nrOfUncertaintySimulations) {
        this.nrOfUncertaintySimulations = nrOfUncertaintySimulations;
    }

    public boolean isPrintMinimalCutsets() {
        return this.printMinimalCutsets;
    }

    public void setPrintMinimalCutsets(boolean printMinimalCutsets) {
        this.printMinimalCutsets = printMinimalCutsets;
    }

    public boolean isComputeTopEventProbability() {
        return this.computeTopEventProbability;
    }

    public void setComputeTopEventProbability(boolean computeTopEventProbability) {
        this.computeTopEventProbability = computeTopEventProbability;
    }

    public boolean isComputeImportanceFactors() {
        return this.computeImportanceFactors;
    }

    public void setComputeImportanceFactors(boolean computeImportanceFactors) {
        this.computeImportanceFactors = computeImportanceFactors;
    }

    public boolean isComputeUncertainty() {
        return this.computeUncertainty;
    }

    public void setComputeUncertainty(boolean computeUncertainty) {
        this.computeUncertainty = computeUncertainty;
    }

    public int getMaxNrOfCutsets() {
        return this.maxNrOfCutsets;
    }

    public void setMaxNrOfCutsets(int maxNrOfCutsets) {
        this.maxNrOfCutsets = maxNrOfCutsets;
    }

    public void setMinProbability(double p) {
        this.minProbability = p;
    }

    public void setMaxOrder(int order) {
        this.maxOrder = order;
    }

    public void setMissionTime(double mt) {
        this.missionTime = mt;
    }

    public String getMcsResultFile() {
        return this.mcsResultFile;
    }

    public void setMCSResultFile(String path) {
        this.mcsResultFile = path;
    }

    public String getTopEventResultFile() {
        return this.topEventResultFile;
    }

    public void setTopEventResultFile(String path) {
        this.topEventResultFile = path;
    }

    public String getImportanceFactorsResultFile() {
        return this.impResultFile;
    }

    public void setImportanceFactorsResultFile(String path) {
        this.impResultFile = path;
    }

    public String getSensitivityResultFile() {
        return this.sensResultFile;
    }

    public void setSensitivityResultFile(String path) {
        this.sensResultFile = path;
    }

    public void setMftInputFile(String path) {
        this.mftFile = path;
    }

    public void setTopEventName(String event) {
        this.topEventName = event;
    }

    public MftInputFormat getMftFormat() {
        return this.mftFormat;
    }

    public void setMftFormat(MftInputFormat mftFormat) {
        this.mftFormat = mftFormat;
    }

    public void createScript(File scriptFile) throws IbeeException {
        this.buf = new StringBuffer();
        this.createLoadPsaModelSection();
        this.createBuildMinimalCutsetsSection();
        if (this.computeTopEventProbability) {
            this.createComputeTopEventSection();
        }
        if (this.printMinimalCutsets) {
            this.createPrintMinimalCutsetsSection();
        }
        if (this.computeImportanceFactors) {
            this.createComputeImportanceFactorsSection();
        }
        try {
            FileWriter writer = new FileWriter(scriptFile);
            writer.write(this.buf.toString());
            writer.close();
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
    }

    private void createLoadPsaModelSection() {
        this.append(String.format("load model \"%s\"%s;", this.mftFile, this.mftFormat == MftInputFormat.OPENPSA ? "format=open-psa" : ""));
    }

    private void createBuildMinimalCutsetsSection() {
        this.append(String.format("build target-model;", new Object[0]));
        this.append(String.format("build BDT %s", this.topEventName));
        if (this.maxNrOfCutsets > 0) {
            this.append(String.format("   maximum-number=%d", this.maxNrOfCutsets));
        }
        if (this.maxOrder > 0) {
            this.append(String.format("   maximum-order=%d", this.maxOrder));
        }
        if (this.minProbability > 0.0) {
            this.append(String.format("   minimum-probability=%.3e", this.minProbability));
        }
        this.append(String.format("   mission-time=%.3e;", this.missionTime));
    }

    private void createComputeTopEventSection() {
        this.append(String.format("compute probability %s", this.topEventName));
        this.append(String.format("   quantification-method=rare-event-approximation", new Object[0]));
        this.append(String.format("   mission-time=%.3e", this.missionTime));
        this.append(String.format("   output=\"%s\"", this.topEventResultFile));
        this.append(String.format("   mode=write;", new Object[0]));
    }

    private void createPrintMinimalCutsetsSection() {
        this.append(String.format("print minimal-cutsets %s", this.topEventName));
        this.append(String.format("   mission-time=%.3e", this.missionTime));
        this.append(String.format("   output=\"%s\";", this.mcsResultFile));
    }

    private void createComputeImportanceFactorsSection() {
        this.append(String.format("compute importance-measures %s", this.topEventName));
        this.append(String.format("   mission-time=%.3e", this.missionTime));
        this.append(String.format("   print-probability=%s", "true"));
        this.append(String.format("   output=\"%s\";", this.impResultFile));
    }

    private void append(String msg) {
        this.buf.append(msg);
        this.buf.append("\n");
    }

    public static enum MftInputFormat {
        SBE,
        OPENPSA;

    }
}

