/*
 * Decompiled with CFR 0.152.
 */
package fr.edf.ibee.swt.core.table;

import fr.edf.ibee.swt.core.table.IObjectFilter;
import fr.edf.ibee.swt.core.table.ITableContentProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class ALazyTableContentProvider
implements ITableContentProvider {
    protected Object[] childs = null;
    protected Object[] childsFiltered = null;
    protected Object modelInput;
    protected IObjectFilter filter = null;
    protected TableViewer viewer;

    public void dispose() {
        this.clearFull();
    }

    @Override
    public Object[] getObjects() {
        if (this.childs != null) {
            return this.childs;
        }
        this.childs = this.determineObjects();
        return this.childs;
    }

    @Override
    public Object[] getObjectsFiltered() {
        if (this.childsFiltered != null) {
            return this.childsFiltered;
        }
        Object[] obj = this.getObjects();
        if (obj == null) {
            obj = new Object[]{};
        }
        ArrayList<Object> obj2 = new ArrayList<Object>(obj.length);
        Object[] objectArray = obj;
        int n = obj.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (this.filter == null || this.filter.select(o)) {
                obj2.add(o);
            }
            ++n2;
        }
        this.childsFiltered = obj2.toArray();
        return this.childsFiltered;
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        this.modelInput = arg2;
        this.viewer = (TableViewer)arg0;
    }

    @Override
    public void refresh() {
        this.childsFiltered = null;
        this.childs = null;
    }

    @Override
    public void clearFilter() {
        this.childsFiltered = null;
    }

    @Override
    public void clearFull() {
        this.childs = null;
        this.childsFiltered = null;
    }

    @Override
    public void setFilter(IObjectFilter filter) {
        this.filter = filter;
    }

    public void updateElement(int index) {
        Object[] list = this.getObjectsFiltered();
        if (index >= list.length) {
            return;
        }
        Object element = this.getObjectsFiltered()[index];
        if (this.viewer.isBusy()) {
            return;
        }
        this.viewer.replace(element, index);
    }
}

