/*
 * Decompiled with CFR 0.152.
 */
package fr.edf.ibee.swt.core.table;

import fr.edf.ibee.swt.core.table.ITableContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class LazyTableViewer
extends TableViewer {
    private boolean nonlazy = false;
    private ITableContentProvider provider;
    private long maxRowsToShow = -1L;

    public LazyTableViewer(Composite parent, int flags, boolean nonLazy) {
        super(new Table(parent, 0x10010000 | flags));
        this.nonlazy = nonLazy;
        this.setUseHashlookup(true);
    }

    public LazyTableViewer(Composite parent, int flags) {
        super(new Table(parent, 0x10010000 | flags));
        this.setUseHashlookup(true);
    }

    public ITableContentProvider getContentProvider() {
        return this.provider;
    }

    public void refresh() {
        try {
            this.getTable().setRedraw(false);
            if (this.nonlazy) {
                super.refresh();
            } else {
                ITableContentProvider provider = this.getContentProvider();
                if (provider == null) {
                    return;
                }
                Object[] list = provider.getObjectsFiltered();
                int length = list.length;
                if (this.maxRowsToShow > 0L && (long)length >= this.maxRowsToShow) {
                    length = (int)this.maxRowsToShow;
                }
                this.setItemCount(length);
                super.refresh();
            }
        }
        finally {
            this.getTable().setRedraw(true);
        }
    }

    public void select(final Object object) {
        if (this.getContentProvider() == null) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        if (object != null && (sel == null || sel.getFirstElement() != object)) {
            this.getTable().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LazyTableViewer.this.selectInternal(object);
                }
            });
        }
    }

    private void selectInternal(Object object) {
        if (object != null) {
            Object[] obj = this.getContentProvider().getObjectsFiltered();
            boolean found = false;
            int index = 0;
            Object[] objectArray = obj;
            int n = obj.length;
            int n2 = 0;
            while (n2 < n) {
                Object test = objectArray[n2];
                if (test == object) {
                    found = true;
                    break;
                }
                ++index;
                ++n2;
            }
            if (!found) {
                return;
            }
            this.getContentProvider().updateElement(index);
        }
        StructuredSelection sel = new StructuredSelection(object);
        this.setSelection((ISelection)sel, false);
    }

    public void setContentProvider(ITableContentProvider contentProvider) {
        this.provider = contentProvider;
        if (this.nonlazy) {
            super.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return LazyTableViewer.this.provider.getObjectsFiltered();
                }
            });
        } else {
            super.setContentProvider((IContentProvider)contentProvider);
        }
    }

    public void setContentProvider(IContentProvider provider) {
        if (provider instanceof ITableContentProvider) {
            this.setContentProvider((ITableContentProvider)provider);
        } else {
            super.setContentProvider(provider);
        }
    }

    public long getMaxRowsToShow() {
        return this.maxRowsToShow;
    }

    public void setMaxRowsToShow(long maxRowsToShow) {
        this.maxRowsToShow = maxRowsToShow;
    }
}

