/*
 * Decompiled with CFR 0.152.
 */
package fr.edf.ibee.swt.core.table;

import fr.edf.ibee.swt.core.table.ITreeContentProvider;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class LazyTreeViewer
extends TreeViewer {
    public LazyTreeViewer(Composite parent, int flags) {
        super(new Tree(parent, 0x10010000 | flags));
        this.setUseHashlookup(true);
    }

    public LazyTreeViewer(int flags, Tree tree) {
        super((Composite)tree, 0x10010000 | flags);
        this.setUseHashlookup(true);
    }

    public ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)super.getContentProvider();
    }

    public void select(Object object) {
        if (this.getContentProvider() == null) {
            return;
        }
        this.selectInternal(object);
    }

    public void selectInternal(Object object) {
        if (object == null) {
            this.setSelection(null, false);
            return;
        }
        Object parent = this.getContentProvider().getParent(object);
        ArrayList<Object> objects = new ArrayList<Object>();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Object> path = new ArrayList<Object>();
        if (object != null) {
            path.add(object);
        }
        while (parent != null) {
            Object[] obj = this.getContentProvider().getObjectsFiltered(parent);
            boolean found = false;
            int index = 0;
            Object[] objectArray = obj;
            int n = obj.length;
            int n2 = 0;
            while (n2 < n) {
                Object test = objectArray[n2];
                if (test == object) {
                    found = true;
                    break;
                }
                ++index;
                ++n2;
            }
            if (!found) {
                this.setSelection(null, false);
                return;
            }
            if (index >= 0) {
                objects.add(parent);
                indices.add(index);
            }
            path.add(0, parent);
            object = parent;
            parent = this.getContentProvider().getParent(object);
        }
        int i = indices.size() - 1;
        while (i >= 0) {
            Object element = this.getContentProvider().getObjectsFiltered(objects.get(i))[(Integer)indices.get(i)];
            this.replace(objects.get(i), (Integer)indices.get(i), element);
            this.getContentProvider().updateChildCount(element, -1);
            --i;
        }
        Object[] segments = new Object[path.size()];
        path.toArray(segments);
        TreeSelection sel2 = new TreeSelection(new TreePath(segments));
        this.setSelection((ISelection)sel2, false);
    }

    public void refresh() {
        try {
            this.getTree().setRedraw(false);
            LazyTreeViewer.super.refresh();
        }
        finally {
            this.getTree().setRedraw(true);
        }
    }
}

