/*
 * Decompiled with CFR 0.152.
 */
package fr.edf.ibee.swt.core.table;

import java.util.Arrays;
import java.util.Collection;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.util.misc.IFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class TableSyntaxHighlighter<T> {
    private Collection<TableItem> items;
    private net.edgemind.ibee.core.diagram.Color color = net.edgemind.ibee.core.diagram.Color.YELLOW;
    private IFilter<T> acceptor;

    public void setColor(net.edgemind.ibee.core.diagram.Color color) {
        this.color = color;
    }

    public TableSyntaxHighlighter(TableItem item, IFilter<T> validator) {
        this(Arrays.asList(item), validator);
    }

    public TableSyntaxHighlighter(Collection<TableItem> items, IFilter<T> validator) {
        this.items = items;
        this.acceptor = validator;
        for (TableItem item : items) {
            Listener editListener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.detail == 24) {
                        TableSyntaxHighlighter.this.update();
                    }
                }
            };
            item.addListener(24, editListener);
        }
        this.update();
    }

    public void update() {
        for (TableItem item : this.items) {
            if (this.acceptor.accept(item.getData())) {
                item.setBackground(null);
                continue;
            }
            Color swtColor = SwtUtil.toSwtColor(this.color);
            item.setBackground(swtColor);
        }
    }
}

