/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.app;

import net.edgemind.ibee.core.app.Event;
import net.edgemind.ibee.core.app.IPart;
import net.edgemind.ibee.core.app.Part;
import net.edgemind.ibee.core.log.LogLevel;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.swt.core.app.ISwtPart;
import net.edgemind.ibee.swt.core.creator.SwtMenuCreator;
import net.edgemind.ibee.ui.app.UiPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class SwtPart
extends Part
implements ISwtPart {
    private Event lastAsyncEvent = null;
    private boolean refreshStored = false;
    private Shell shell;
    private Composite parent;
    private Control control;

    protected abstract Control createContents(Composite var1);

    public void addPart(IPart part) {
        super.addPart(part);
    }

    @Override
    public Control create(Composite parent) {
        this.parent = parent;
        this.shell = parent.getShell();
        this.control = this.createContents(parent);
        return this.control;
    }

    public synchronized void fireEventAsync(final Event event) {
        if (this.lastAsyncEvent != null && event.equals(this.lastAsyncEvent)) {
            LogUtil.log((String)("[" + this.getId() + "] ignore fireEventAsync event " + event.getId()), (LogLevel)LogLevel.DEBUG);
            return;
        }
        this.lastAsyncEvent = event;
        this.shell.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SwtPart swtPart = SwtPart.this;
                synchronized (swtPart) {
                    SwtPart.this.lastAsyncEvent = null;
                }
                SwtPart.this.fireEvent(event);
            }
        });
    }

    public synchronized void refresh(final boolean force) {
        if (!this.refreshStored || force) {
            this.refreshStored = true;
            if (this.shell.isDisposed()) {
                return;
            }
            this.shell.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SwtPart swtPart = SwtPart.this;
                    synchronized (swtPart) {
                        SwtPart.this.refreshStored = false;
                    }
                    SwtPart.super.refresh(force);
                }
            });
        }
    }

    @Override
    public Shell getShell() {
        if (this.parent != null) {
            return this.parent.getShell();
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public void createPopup(Control parent) {
        String menuId = this.getId();
        this.createPopup(menuId, parent);
    }

    public void createPopup(String menuId, Control parent) {
        SwtMenuCreator creator = new SwtMenuCreator();
        creator.createPopup(menuId, (UiPart)this, parent);
    }
}

