/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.swt.core.dialog.IRunnable;
import net.edgemind.ibee.swt.core.dialog.IRunnableWithoutError;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class ADialog {
    protected Rectangle mSize;
    protected Shell shell = null;
    protected String mBtnDoneName = "Done";
    protected String mBtnCancelName = "Cancel";
    protected String mTitle = "untitled";
    private boolean mDoPack = true;
    protected boolean mIsValid;
    protected Button btnCancel;
    protected Button btnDone;
    private DialogStatus status = DialogStatus.INIT;
    protected boolean blocking = true;
    protected int style;
    protected Shell parent;
    public List<Consumer<ADialog>> onOpenConsumers = new ArrayList<Consumer<ADialog>>();
    public List<Function<ADialog, Boolean>> onCloseValidatorFcts = new ArrayList<Function<ADialog, Boolean>>();
    public List<Function<ADialog, Boolean>> onDoneValidatorFcts = new ArrayList<Function<ADialog, Boolean>>();
    public List<Function<ADialog, Boolean>> onCancelValidatorFcts = new ArrayList<Function<ADialog, Boolean>>();
    public List<Consumer<ADialog>> onDoneConsumers = new ArrayList<Consumer<ADialog>>();
    public List<Consumer<ADialog>> onCancelConsumers = new ArrayList<Consumer<ADialog>>();
    public List<Consumer<ADialog>> onCloseConsumers = new ArrayList<Consumer<ADialog>>();

    public abstract void createContents(Composite var1);

    public ADialog(Shell parent, String title) {
        this(parent, 67696, title);
    }

    public ADialog(Shell parent, int style, String title) {
        this.parent = parent;
        this.style = style;
        this.mTitle = title;
        this.mIsValid = false;
    }

    public void setAllowResize(boolean value) {
        this.style = value ? (this.style |= 0x10) : (this.style &= 0xFFFFFFEF);
    }

    public void setDoPack(boolean value) {
        this.mDoPack = value;
    }

    public void setBlocking(boolean value) {
        this.blocking = value;
    }

    public void initSize(final double scaleX, final double scaleY) {
        SwtUtil.runInGui(new IRunnable(){

            @Override
            public void run() throws IbeeException {
                Rectangle bounds = ADialog.this.getTargetMonitor().getBounds();
                bounds.x = -1;
                bounds.y = -1;
                bounds.width = scaleX >= 0.0 ? (int)((double)bounds.width * scaleX) : -1;
                bounds.height = scaleY >= 0.0 ? (int)((double)bounds.height * scaleY) : -1;
                ADialog.this.mSize = bounds;
            }
        }, this.parent);
    }

    public void initSize(final Point widthHeight) {
        SwtUtil.runInGui(new IRunnable(){

            @Override
            public void run() throws IbeeException {
                Rectangle bounds = ADialog.this.getTargetMonitor().getBounds();
                bounds.x = -1;
                bounds.y = -1;
                bounds.width = -1;
                bounds.height = -1;
                if (widthHeight.x >= 0) {
                    bounds.width = widthHeight.x;
                }
                if (widthHeight.y >= 0) {
                    bounds.height = widthHeight.y;
                }
                ADialog.this.mSize = bounds;
            }
        }, this.parent);
    }

    public void initSize(Rectangle size) {
        this.mSize = size;
    }

    public void open() {
        this.status = DialogStatus.OPEN;
        if (this.parent == null) {
            this.openUi();
        } else {
            SwtUtil.runInGui(new IRunnableWithoutError(){

                @Override
                public void run() {
                    ADialog.this.openUi();
                }
            }, this.parent);
        }
    }

    protected void openUi() {
        this.shell = this.parent != null ? new Shell(this.getParentShell(), this.getStyle()) : new Shell(this.getStyle());
        if (this.mTitle != null) {
            this.shell.setText(this.mTitle);
        }
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = ADialog.this.closeInternal();
            }
        });
        GridLayout layout = new GridLayout(1, false);
        this.shell.setLayout((Layout)layout);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 4) {
                    ADialog.this.done();
                } else if (event.detail == 2) {
                    ADialog.this.cancel();
                }
            }
        });
        this.createContents((Composite)this.shell);
        this.adaptSize();
        this.shell.open();
        for (Consumer<ADialog> d : this.onOpenConsumers) {
            d.accept(this);
        }
        if (this.blocking) {
            Display display = this.shell.getDisplay();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    private Monitor getTargetMonitor() {
        Monitor monitor = this.parent != null ? this.parent.getMonitor() : Display.getCurrent().getPrimaryMonitor();
        return monitor;
    }

    private void adaptSize() {
        Point minBounds = this.shell.computeSize(-1, -1);
        if (this.mDoPack) {
            this.shell.pack();
        }
        Rectangle dialogBounds = this.shell.getBounds();
        boolean centerX = true;
        boolean centerY = true;
        if (this.mSize != null) {
            if (this.mSize.width >= 0) {
                dialogBounds.width = this.mSize.width;
            }
            if (this.mSize.height >= 0) {
                dialogBounds.height = this.mSize.height;
            }
            if (this.mSize.x >= 0) {
                dialogBounds.x = this.mSize.x;
                centerX = false;
            }
            if (this.mSize.y >= 0) {
                dialogBounds.y = this.mSize.y;
                centerY = false;
            }
        }
        if (dialogBounds.width < minBounds.x) {
            minBounds.x = dialogBounds.width;
        }
        if (dialogBounds.height < minBounds.y) {
            minBounds.y = dialogBounds.height;
        }
        Rectangle targetMonitorOffset = this.getTargetMonitor().getBounds();
        dialogBounds.x = centerX ? targetMonitorOffset.x + (targetMonitorOffset.width - dialogBounds.width) / 2 : targetMonitorOffset.x + dialogBounds.x;
        dialogBounds.y = centerY ? targetMonitorOffset.y + (targetMonitorOffset.height - dialogBounds.height) / 2 : targetMonitorOffset.y + dialogBounds.y;
        this.shell.setMinimumSize(minBounds.x, minBounds.y);
        this.shell.setBounds(dialogBounds);
    }

    protected void createCtrl(Composite parent) {
        Composite compositeCtrl = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        compositeCtrl.setLayoutData((Object)gridData);
        compositeCtrl.setLayout((Layout)new GridLayout(2, false));
        if (this.mBtnCancelName != null && this.mBtnCancelName.length() > 0) {
            this.btnCancel = new Button(compositeCtrl, 0);
            this.btnCancel.setText(this.mBtnCancelName);
            this.btnCancel.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ADialog.this.cancel();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
        if (this.mBtnDoneName != null && this.mBtnDoneName.length() > 0) {
            this.btnDone = new Button(compositeCtrl, 0);
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = true;
            this.btnDone.setLayoutData((Object)gridData);
            this.btnDone.setText(this.mBtnDoneName);
            this.btnDone.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    ADialog.this.done();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setIsValid(boolean value) {
        this.mIsValid = value;
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public void setDoneButtonName(String name) {
        this.mBtnDoneName = name;
        if (this.btnDone != null) {
            SwtUtil.runInGui(new IRunnable(){

                @Override
                public void run() throws IbeeException {
                    ADialog.this.btnDone.setText(ADialog.this.mBtnDoneName);
                }
            }, this.shell);
        }
    }

    public void setCancelButtonName(String name) {
        this.mBtnCancelName = name;
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setParentShell(Shell shell) {
        this.parent = shell;
    }

    public Shell getParentShell() {
        return this.parent;
    }

    public int getStyle() {
        return this.style;
    }

    public void refresh() {
    }

    public DialogStatus getDialogStatus() {
        return this.status;
    }

    protected final boolean done() {
        if (!this.doneInternal()) {
            return false;
        }
        this.close();
        return true;
    }

    private boolean doneInternal() {
        for (Function<ADialog, Boolean> fct : this.onDoneValidatorFcts) {
            if (fct.apply(this).booleanValue()) continue;
            return false;
        }
        if (!this.prepareDone()) {
            return false;
        }
        this.performDialogDone();
        this.status = DialogStatus.DONE;
        this.setIsValid(true);
        return true;
    }

    protected boolean prepareDone() {
        return true;
    }

    protected void performDialogDone() {
    }

    public boolean allowCancel() {
        return true;
    }

    protected final boolean cancel() {
        if (!this.cancelInternal()) {
            return false;
        }
        this.close();
        return true;
    }

    private boolean cancelInternal() {
        for (Function<ADialog, Boolean> fct : this.onCancelValidatorFcts) {
            if (fct.apply(this).booleanValue()) continue;
            return false;
        }
        if (!this.allowCancel()) {
            return false;
        }
        this.performDialogCancel();
        this.status = DialogStatus.CANCEL;
        this.setIsValid(false);
        return true;
    }

    protected void performDialogCancel() {
    }

    protected final void close() {
        if (!this.shell.isDisposed()) {
            this.shell.close();
        }
    }

    private boolean closeInternal() {
        if (this.status == DialogStatus.OPEN && (this.mIsValid ? !this.doneInternal() : !this.cancelInternal())) {
            return false;
        }
        for (Function<ADialog, Boolean> fct : this.onCloseValidatorFcts) {
            if (fct.apply(this).booleanValue()) continue;
            return false;
        }
        if (!this.allowClose()) {
            return false;
        }
        this.performDialogClose();
        this.shell.getDisplay().asyncExec(() -> {
            if (this.status == DialogStatus.CANCEL) {
                this.notifyConsumers(this.onCancelConsumers);
            } else if (this.status == DialogStatus.DONE) {
                this.notifyConsumers(this.onDoneConsumers);
            }
            this.notifyConsumers(this.onCloseConsumers);
        });
        return true;
    }

    protected boolean allowClose() {
        return true;
    }

    protected void performDialogClose() {
    }

    public void onClose(Consumer<ADialog> proc) {
        this.onCloseConsumers.add(proc);
    }

    public void onCloseValidator(Function<ADialog, Boolean> fct) {
        this.onCloseValidatorFcts.add(fct);
    }

    public void onOpen(Consumer<ADialog> proc) {
        this.onOpenConsumers.add(proc);
    }

    public void onDoneValidator(Function<ADialog, Boolean> fct) {
        this.onDoneValidatorFcts.add(fct);
    }

    public void onDone(Consumer<ADialog> proc) {
        this.onDoneConsumers.add(proc);
    }

    public void onCancelValidator(Function<ADialog, Boolean> fct) {
        this.onCancelValidatorFcts.add(fct);
    }

    public void onCancel(Consumer<ADialog> proc) {
        this.onCancelConsumers.add(proc);
    }

    private <T> void notifyConsumers(List<Consumer<ADialog>> consumers) {
        for (Consumer<ADialog> proc : consumers) {
            proc.accept(this);
        }
    }

    public static enum DialogStatus {
        INIT,
        OPEN,
        DONE,
        CANCEL;

    }
}

