/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.dialog;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import net.edgemind.ibee.core.log.ILogHandler;
import net.edgemind.ibee.swt.core.dialog.ADialog;
import net.edgemind.ibee.swt.core.dialog.IRunnableWithProgress;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.FileField;
import net.edgemind.ibee.swt.core.field.SwtFieldCreator;
import net.edgemind.ibee.swt.core.handler.BatchLogHandler;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.swt.core.widgets.SwtExecutionWidget;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AExecutionDialog
extends ADialog {
    protected String mBtnCloseName = "Close";
    protected Button btnClose;
    protected SwtFieldCreator creator;
    protected SwtExecutionWidget execWidget;
    protected boolean batchLog = false;
    private boolean displayEndInfoDialog = false;

    protected boolean launchPre() {
        return true;
    }

    protected boolean launchPost() {
        return true;
    }

    public void setDisplayEndInfoDialog(boolean displayEndInfoDialog) {
        this.displayEndInfoDialog = displayEndInfoDialog;
    }

    public AExecutionDialog(Shell parent, String title) {
        super(parent, title);
    }

    public AExecutionDialog(Shell parent, int style, String title) {
        super(parent, style, title);
        this.creator = new SwtFieldCreator();
        this.creator.setShowDescription(true);
    }

    @Override
    public boolean allowClose() {
        if (this.isRunning()) {
            SwtUtil.openInfoDlg(this.shell, "Execution in progress", "Execution in progress, please wait...");
            return false;
        }
        return true;
    }

    private boolean isRunning() {
        return this.execWidget != null && this.execWidget.isRunning();
    }

    @Override
    public void createContents(Composite parent) {
        this.createConfigSection(parent);
        this.createLaunchWidget(parent);
        this.createCtrl(parent);
    }

    public void createLaunchWidget(Composite parent) {
        this.execWidget = this.createControl(parent);
        IRunnableWithProgress runnable = progress -> {
            if (!this.isValid(this.creator)) {
                return;
            }
            this.perform(this.execWidget, progress);
            this.finished();
        };
        this.execWidget.setRunnable(runnable);
    }

    protected SwtExecutionWidget createControl(Composite parent) {
        SwtExecutionWidget exec = new SwtExecutionWidget(){

            @Override
            protected boolean launchPre() {
                if (!AExecutionDialog.this.isValid(AExecutionDialog.this.creator)) {
                    return false;
                }
                return AExecutionDialog.this.launchPre();
            }

            @Override
            protected boolean launchPost() {
                if (this.logHandler instanceof BatchLogHandler) {
                    ((BatchLogHandler)this.logHandler).setFile(null);
                }
                return AExecutionDialog.this.launchPost();
            }

            @Override
            protected ILogHandler createLogHandler() {
                if (AExecutionDialog.this.batchLog) {
                    BatchLogHandler logHandler = new BatchLogHandler(null, this.logWidget);
                    return logHandler;
                }
                return super.createLogHandler();
            }
        };
        this.configureExecutionWidget(exec);
        exec.create(parent, this.style);
        return exec;
    }

    protected void configureExecutionWidget(SwtExecutionWidget exec) {
        exec.setCreateLauncherHeader(true);
        exec.setCreateLog(true);
        exec.setCreateTaskInfo(true);
        exec.setLogSize(new Point(-1, -1));
        exec.setCreateProgressBar(true);
        exec.setLogSubTasks(true);
    }

    @Override
    protected void createCtrl(Composite parent) {
        Composite compositeCtrl = new Composite(parent, 0);
        GridData gridData = new GridData(128);
        compositeCtrl.setLayoutData((Object)gridData);
        compositeCtrl.setLayout((Layout)new GridLayout(1, false));
        if (this.mBtnCloseName != null && this.mBtnCloseName.length() > 0) {
            this.btnClose = new Button(compositeCtrl, 0);
            this.btnClose.setText(this.mBtnCloseName);
            this.btnClose.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    AExecutionDialog.this.close();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
    }

    public boolean isValid(SwtFieldCreator creator) {
        String msg = creator.getErrorMsg();
        if (msg != null) {
            SwtUtil.showInfo("Invalid Configuration", msg, this.shell);
            return false;
        }
        return true;
    }

    protected <T> void addFieldNotEmptyChecker(FieldData<T> field, final Function<FieldData<T>, Boolean> toCheck) {
        field.addFieldChecker(new FieldData.FieldChecker<T>(){

            @Override
            public String getErrorMsg(FieldData<T> field) {
                if (!((Boolean)toCheck.apply(field)).booleanValue()) {
                    return null;
                }
                if (field.isEmpty()) {
                    return "Value must not be empty";
                }
                return null;
            }
        });
    }

    protected void addFileExtensionChecker(final FileField field, final Function<FileField, Boolean> toCheck, final Supplier<String[]> allowedExtensions) {
        field.addFieldChecker(new FieldData.FieldChecker<String>(){

            @Override
            public String getErrorMsg(FieldData<String> f) {
                if (!((Boolean)toCheck.apply(field)).booleanValue()) {
                    return null;
                }
                String value = (String)field.getValue();
                if (value == null || value.equals("")) {
                    return null;
                }
                CharSequence[] extensions = (String[])allowedExtensions.get();
                if (!Arrays.asList(extensions).stream().anyMatch(ext -> FileUtil.hasExtension((String)value, (String)ext))) {
                    String str = String.join((CharSequence)";", extensions);
                    return "File must have extension '" + str + "'";
                }
                return null;
            }
        });
    }

    protected void addFileExistsChecker(FileField field, final Function<FieldData<String>, Boolean> toCheck) {
        field.addFieldChecker(new FieldData.FieldChecker<String>(){

            @Override
            public String getErrorMsg(FieldData<String> field) {
                if (!((Boolean)toCheck.apply(field)).booleanValue()) {
                    return null;
                }
                if (field.isEmpty()) {
                    return null;
                }
                String value = field.getValue();
                if (!FileUtil.fileExists((String)value)) {
                    return "File '" + field.getValue() + "' does not exist";
                }
                return null;
            }
        });
    }

    public abstract void createConfigSection(Composite var1);

    public abstract void perform(SwtExecutionWidget var1, IProgressMonitor var2);

    protected void finished() {
        boolean errorDialogOppended = this.openDialogIfProblemOrCancelled();
        if (!errorDialogOppended && this.displayEndInfoDialog) {
            this.openDialogAtEnd();
        }
    }

    private boolean openDialogIfProblemOrCancelled() {
        if (this.execWidget.isCancelled()) {
            SwtUtil.openInfoDlg(this.shell, "Cancelled", "'" + this.mTitle + "' has been cancelled.");
            return true;
        }
        return false;
    }

    private void openDialogAtEnd() {
        this.getShell().getDisplay().syncExec(() -> SwtUtil.showInfo(this.getTitle() + " finished", "Execution of '" + this.getTitle() + "' finished.", this.getShell()));
    }
}

