/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.dialog;

import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.swt.core.dialog.ADialog;
import net.edgemind.ibee.swt.core.field.CheckboxField;
import net.edgemind.ibee.swt.core.field.DropdownField;
import net.edgemind.ibee.swt.core.field.DropdownFieldSB;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.FileField;
import net.edgemind.ibee.swt.core.field.SpinnerField;
import net.edgemind.ibee.swt.core.field.StringField;
import net.edgemind.ibee.swt.core.field.SwtFieldCreator;
import net.edgemind.ibee.ui.dialog.IDialog;
import net.edgemind.ibee.ui.dialog.IDialogDesc;
import net.edgemind.ibee.ui.dialog.PropertyDialog;
import net.edgemind.ibee.ui.property.CheckboxProperty;
import net.edgemind.ibee.ui.property.EnumProperty;
import net.edgemind.ibee.ui.property.IProperty;
import net.edgemind.ibee.ui.property.IPropertyModificationListener;
import net.edgemind.ibee.ui.property.IntegerProperty;
import net.edgemind.ibee.ui.property.StringProperty;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SwtPropertyDlg
extends ADialog {
    private PropertyDialog dialog;
    private SwtFieldCreator creator;
    private List<String> listEnum = new ArrayList<String>();

    public void setEnum(List<String> listEnum) {
        this.listEnum.addAll(listEnum);
    }

    public SwtPropertyDlg(PropertyDialog dialog, Shell parent) {
        super(parent, dialog.getTitle());
        this.dialog = dialog;
    }

    @Override
    public void createContents(Composite parent) {
        this.creator = new SwtFieldCreator();
        ScrolledComposite scrolled = new ScrolledComposite(parent, 768);
        scrolled.setLayoutData((Object)new GridData(1808));
        scrolled.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)scrolled, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        scrolled.setContent((Control)composite);
        for (IProperty property : this.dialog.getPropertySheet().getProperties()) {
            if (property instanceof StringProperty) {
                this.createStringProperty((StringProperty)property, composite);
                continue;
            }
            if (property instanceof EnumProperty) {
                this.createEnumProperty((EnumProperty<Object>)((EnumProperty)property), composite);
                continue;
            }
            if (property instanceof IntegerProperty) {
                this.createIntegerProperty((IntegerProperty)property, composite);
                continue;
            }
            if (!(property instanceof CheckboxProperty)) continue;
            this.createCheckboxProperty((CheckboxProperty)property, composite);
        }
        composite.setSize(composite.computeSize(-1, -1));
        super.createCtrl(parent);
        Point p = parent.computeSize(-1, -1);
        Rectangle bounds = Display.getCurrent().getPrimaryMonitor().getBounds();
        if ((double)p.y > 0.5 * (double)bounds.height) {
            super.initSize(-1.0, 0.5);
        }
        this.updateDoneButton();
        super.setDoPack(true);
    }

    private void createIntegerProperty(final IntegerProperty property, Composite parent) {
        int value = property.getValue() != null ? (Integer)property.getValue() : 0;
        final SpinnerField field = new SpinnerField("value", property.getLabel(), value);
        field.setMin(property.getMin());
        field.setMax(property.getMax());
        GridData data = new GridData(768);
        data.minimumWidth = 200;
        data.horizontalSpan = field.getColSpan();
        field.setFieldLayout(data);
        field.addModifiedListener(new FieldData.IModifiedListener<Integer>(){

            @Override
            public void modified(Integer value) {
                property.setValue((Object)value);
                SwtPropertyDlg.this.updateField((IProperty<?>)property, field);
                SwtPropertyDlg.this.updateDoneButton();
            }
        });
        this.creator.createField(field, parent);
        this.updateField((IProperty<?>)property, field);
    }

    private void createStringProperty(final StringProperty property, Composite parent) {
        FieldData field;
        if (property.getData(PropertyDialog.SET_IS_FILE) == Boolean.TRUE || property.getData(PropertyDialog.SET_IS_FOLDER) == Boolean.TRUE) {
            boolean isFolder = property.getData(PropertyDialog.SET_IS_FOLDER) == Boolean.TRUE;
            boolean fileWrite = property.getData(PropertyDialog.SET_FILE_WRITE) == Boolean.TRUE;
            field = new FileField(property.getName(), property.getLabel(), (String)property.getValue(), isFolder, fileWrite);
            ((FileField)field).setEditable(property.getModifyable());
        } else if (property.getEnums() != null && property.getEnums().size() > 0) {
            field = new DropdownFieldSB(property.getName(), property.getLabel(), (List<String>)property.getEnums(), property.getEnums(), (String)property.getValue());
            ((DropdownFieldSB)field).setWriteable(property.getModifyable());
        } else {
            field = new StringField(property.getName(), property.getLabel(), (String)property.getValue());
            ((StringField)field).setReadOnly(!property.getModifyable());
        }
        GridData data = new GridData(768);
        data.minimumWidth = 200;
        data.horizontalSpan = field.getColSpan();
        field.setFieldLayout(data);
        property.addModificationListener((IPropertyModificationListener)new IPropertyModificationListener<String>(){

            public void propertyModified(IProperty<String> property) {
                field.setValue((String)property.getValue());
                SwtPropertyDlg.this.updateField(property, field);
                SwtPropertyDlg.this.updateDoneButton();
            }
        });
        field.addModifiedListener(new FieldData.IModifiedListener<String>(){

            @Override
            public void modified(String value) {
                property.setValue((Object)value);
                SwtPropertyDlg.this.updateField((IProperty<?>)property, field);
                SwtPropertyDlg.this.updateDoneButton();
            }
        });
        this.creator.createField(field, parent);
        if (property.getData(PropertyDialog.SELECT_FULL_TEXT) == Boolean.TRUE && property.getValue() != null && ((String)property.getValue()).length() > 0) {
            ((Text)field.getControl()).setSelection(0, ((String)property.getValue()).length());
        }
        if (property.getData(PropertyDialog.SET_FOCUS) == Boolean.TRUE && field.getControl() != null) {
            field.getControl().setFocus();
        }
        this.updateField((IProperty<?>)property, field);
    }

    private void createCheckboxProperty(final CheckboxProperty property, Composite parent) {
        final CheckboxField field = new CheckboxField(property.getName(), property.getLabel(), (Boolean)property.getValue());
        field.setLabel(property.getLabel());
        field.addModifiedListener(new FieldData.IModifiedListener<Boolean>(){

            @Override
            public void modified(Boolean value) {
                if (value != property.getValue()) {
                    property.setValue((Object)value);
                    SwtPropertyDlg.this.updateField((IProperty<?>)property, field);
                    SwtPropertyDlg.this.updateDoneButton();
                }
            }
        });
        property.addModificationListener((IPropertyModificationListener)new IPropertyModificationListener<Boolean>(){

            public void propertyModified(IProperty<Boolean> property) {
                if (field.getIsChecked() != ((Boolean)property.getValue()).booleanValue()) {
                    field.setValue((Boolean)property.getValue());
                }
            }
        });
        this.creator.createField(field, parent);
        this.updateField((IProperty<?>)property, field);
    }

    private void createEnumProperty(final EnumProperty<Object> property, Composite parent) {
        int size = property.getEnums().size();
        int startIndex = 0;
        if (property.getNullAllowed()) {
            ++size;
            startIndex = 1;
        }
        String[] options = new String[size];
        Object[] values = new Object[size];
        if (property.getNullAllowed()) {
            options[0] = property.getNullName();
            values[0] = null;
        }
        int index = 0;
        while (index < property.getEnums().size()) {
            values[startIndex + index] = property.getEnums().get(index);
            options[startIndex + index] = (String)property.getEnumLabels().get(index);
            ++index;
        }
        Object defaultValue = property.getValue();
        final DropdownField<Object> field = new DropdownField<Object>(property.getName(), property.getLabel(), options, values, defaultValue);
        field.setEnabled(property.getModifyable());
        field.addModifiedListener(new FieldData.IModifiedListener<Object>(){

            @Override
            public void modified(Object value) {
                property.setValue(value);
                SwtPropertyDlg.this.updateDoneButton();
            }
        });
        property.addModificationListener((IPropertyModificationListener)new IPropertyModificationListener<Object>(){

            public void propertyModified(IProperty<Object> property) {
                int index;
                EnumProperty enumProperty = (EnumProperty)property;
                int size = enumProperty.getEnumLabels().size();
                if (enumProperty.getNullAllowed()) {
                    ++size;
                }
                Object[] v = new Object[size];
                String[] l = new String[v.length];
                boolean asChanged = false;
                T[] enums = field.getEnums();
                String[] enumsLabels = field.getEnumsLabels();
                List enumsProperty = enumProperty.getEnums();
                List enumsLabelsProperty = enumProperty.getEnumLabels();
                if (enumProperty.getNullAllowed()) {
                    enumsProperty.add(0, null);
                    enumsLabelsProperty.add(0, enumProperty.getNullName());
                }
                if (v.length != enums.length || l.length != enumsLabels.length) {
                    asChanged = true;
                } else {
                    index = 0;
                    while (index < enums.length) {
                        if (enums[index] != enumsProperty.get(index) || !enumsLabels[index].equals(enumsLabelsProperty.get(index))) {
                            asChanged = true;
                        }
                        ++index;
                    }
                }
                index = 0;
                while (index < v.length) {
                    v[index] = enumsProperty.get(index);
                    l[index] = (String)enumsLabelsProperty.get(index);
                    ++index;
                }
                if (asChanged) {
                    field.updateOptions(l, v);
                }
                field.setEnabled(property.getModifyable());
            }
        });
        this.creator.createField(field, parent);
    }

    public void center() {
    }

    public void show() {
        super.open();
    }

    private void updateDoneButton() {
        if (this.btnDone != null) {
            this.btnDone.setEnabled(this.canDone());
        }
    }

    private void updateField(IProperty<?> property, FieldData field) {
        Control control = field.getControl();
        if (property.isValid()) {
            control.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            control.setBackground(Display.getCurrent().getSystemColor(7));
        }
    }

    @Override
    public boolean prepareDone() {
        boolean valid = this.canDone();
        if (valid) {
            this.doDone();
        }
        return valid;
    }

    public boolean canDone() {
        boolean valid = true;
        for (IProperty property : this.dialog.getPropertySheet().getProperties()) {
            if (property.isValid() || !property.isCritical()) continue;
            valid = false;
        }
        return valid;
    }

    public void doDone() {
        boolean valid = true;
        for (IProperty property : this.dialog.getPropertySheet().getProperties()) {
            if (property.isValid() || !property.isCritical()) continue;
            valid = false;
            break;
        }
        if (!valid) {
            return;
        }
        this.dialog.setValid(true);
        IDialogDesc.ICloseHandler handler = this.dialog.getCloseHandler();
        if (handler != null) {
            handler.close((IDialog)this.dialog);
        }
    }
}

