/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import net.edgemind.ibee.swt.core.field.FieldData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ButtonField<T>
extends FieldData<T> {
    private Button button;
    private IButtonPressed<T> callBack;
    private int horizontalAlignment;

    public Button getButton() {
        return this.button;
    }

    public ButtonField(String key, String label, T defaultValue, IButtonPressed<T> callBack) {
        super(key, label, defaultValue);
        this.callBack = callBack;
        this.setButtonHorizontalAlignment(16384);
    }

    public void setButtonHorizontalAlignment(int horizontalAlignment) {
        if (horizontalAlignment == 16384 || horizontalAlignment == 131072 || horizontalAlignment == 0x1000000) {
            this.horizontalAlignment = horizontalAlignment;
            this.setFieldLayout(new GridData(this.horizontalAlignment, 0x1000000, true, true, 0, 0));
        }
    }

    @Override
    public Control createContents(Composite parent) {
        Composite subC = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        subC.setLayoutData((Object)gridData);
        subC.setLayout((Layout)new GridLayout());
        this.button = new Button(subC, 0);
        this.button.setText(this.mLabel);
        this.button.setAlignment(0x1000000);
        this.button.addListener(13, e -> {
            FieldData<T> fieldData = this.setValue(this.callBack.getValue(this));
        });
        return this.button;
    }

    @Override
    public void updateUi() {
    }

    public static interface IButtonPressed<T> {
        public T getValue(FieldData<T> var1);
    }
}

