/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CharsLimitChecker
implements FieldData.FieldChecker<String> {
    public int charLimit = -1;
    public FieldData<String> field;
    public Color color = Color.YELLOW;

    public void setColor(Color color) {
        this.color = color;
    }

    public CharsLimitChecker(FieldData<String> field, int charLimit) {
        this.charLimit = charLimit;
        this.field = field;
        field.addModifiedListener(new FieldData.IModifiedListener(){

            public void modified(Object value) {
                CharsLimitChecker.this.update();
            }
        });
        this.update();
    }

    @Override
    public String getErrorMsg(FieldData<String> field) {
        String text = field.getValue();
        if (text != null && text.trim().length() > this.charLimit) {
            return "Character limit exceeded";
        }
        return null;
    }

    public void update() {
        Control control = this.field.getControl();
        if (control != null) {
            String text = this.field.getValue();
            if (text.trim().length() > this.charLimit) {
                control.setBackground(SwtUtil.toSwtColor(this.color));
            } else {
                control.setBackground(Display.getCurrent().getSystemColor(1));
            }
        }
    }
}

