/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import java.util.Arrays;
import java.util.List;
import net.edgemind.ibee.swt.core.field.CallbackField;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DropdownField<T>
extends FieldData<T> {
    private String[] mLabels = null;
    private T[] mValues = null;
    private Composite combo;
    protected boolean isNative = true;
    private boolean writeable = false;
    private boolean allowResetNull = false;
    private Runnable editHandler = null;
    private Label label;

    public void setWriteable(boolean value) {
        this.writeable = value;
    }

    public void setAllowResetNull(boolean value) {
        this.allowResetNull = value;
    }

    public void setEditHandler(Runnable value) {
        this.editHandler = value;
    }

    public DropdownField(String key, String label, List<String> labels, List<T> values, T defaultValue) {
        super(key, label, defaultValue);
        this.mLabels = new String[labels.size()];
        labels.toArray(this.mLabels);
        this.mValues = values.toArray();
    }

    public DropdownField(String key, String label, String[] labels, T[] values, T defaultValue) {
        super(key, label, defaultValue);
        this.mLabels = labels;
        this.mValues = values;
    }

    public DropdownField(String key, String label, List<T> values, T defaultValue) {
        this(key, label, values.toArray(), defaultValue);
    }

    public DropdownField(String key, String label, T[] values, T defaultValue) {
        super(key, label, defaultValue);
        this.mValues = values;
        int cnt = 0;
        if (values != null) {
            cnt = values.length;
        }
        this.mLabels = new String[cnt];
        int i = 0;
        while (i < cnt) {
            this.mLabels[i] = values[i].toString();
            ++i;
        }
    }

    public String getOption(Object value) {
        if (value == null) {
            return null;
        }
        int index = 0;
        T[] TArray = this.mValues;
        int n = this.mValues.length;
        int n2 = 0;
        while (n2 < n) {
            T o = TArray[n2];
            if (o.equals(value)) {
                return this.mLabels[index];
            }
            ++index;
            ++n2;
        }
        return null;
    }

    public void updateOptions(String[] labels, T[] values) {
        this.updateOptions(Arrays.asList(labels), Arrays.asList(values));
    }

    public void updateOptions(List<String> labels, List<T> values) {
        this.mLabels = labels.toArray(new String[0]);
        this.mValues = values.toArray();
        if (this.isNative) {
            ((Combo)this.combo).removeAll();
            for (String label : labels) {
                ((Combo)this.combo).add(label);
            }
        } else {
            ((CCombo)this.combo).removeAll();
            for (String label : labels) {
                ((CCombo)this.combo).add(label);
            }
        }
        this.updateUi();
    }

    public String[] getOptions() {
        return this.mLabels;
    }

    @Override
    public void updateUi() {
        int index = this.getSelectionIndex();
        if (index >= 0) {
            if (this.isNative) {
                Combo cmb = (Combo)this.getControl();
                if (cmb == null) {
                    return;
                }
                cmb.select(index);
            } else {
                CCombo cmb = (CCombo)this.getControl();
                if (cmb == null) {
                    return;
                }
                cmb.select(index);
            }
        }
    }

    @Override
    public Control createContents(Composite parent) {
        this.label = new Label(parent, 0);
        this.label.setText(this.mLabel + ": ");
        if (this.mLabelLayout != null) {
            this.label.setLayoutData(this.mLabelLayout);
        }
        int span = 1;
        if (this.allowResetNull) {
            ++span;
        }
        if (this.editHandler != null) {
            ++span;
        }
        Composite subC = new Composite(parent, 0);
        subC.setLayout((Layout)SwtUtil.createLayout(span, 0));
        GridData gridData = new GridData(768);
        subC.setLayoutData((Object)gridData);
        if (this.isNative) {
            this.combo = new Combo(subC, (this.writeable ? 0 : 8) | 0x800);
            if (this.mValues != null && this.mLabels != null) {
                String[] stringArray = this.mLabels;
                int n = this.mLabels.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    ((Combo)this.combo).add(value);
                    ++n2;
                }
            }
            ((Combo)this.combo).addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ((Combo)DropdownField.this.combo).getSelectionIndex();
                    if (index >= 0 && index < DropdownField.this.mValues.length) {
                        DropdownField.this.setValue(DropdownField.this.mValues[index]);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.writeable) {
                ((Combo)this.combo).addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String result = ((Combo)DropdownField.this.combo).getText();
                        DropdownField.this.setValue(result);
                    }
                });
            }
            if ((index = this.getSelectionIndex()) >= 0) {
                ((Combo)this.combo).select(index);
            }
        } else {
            this.combo = new CCombo(subC, (this.writeable ? 0 : 8) | 0x800);
            if (this.mValues != null && this.mLabels != null) {
                String[] stringArray = this.mLabels;
                int n = this.mLabels.length;
                int n3 = 0;
                while (n3 < n) {
                    String value = stringArray[n3];
                    ((CCombo)this.combo).add(value);
                    ++n3;
                }
            }
            ((CCombo)this.combo).addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ((CCombo)DropdownField.this.combo).getSelectionIndex();
                    if (index >= 0) {
                        DropdownField.this.setValue(DropdownField.this.mValues[index]);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (this.writeable) {
                ((CCombo)this.combo).addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String result = ((CCombo)DropdownField.this.combo).getText();
                        DropdownField.this.setValue(result);
                    }
                });
            }
            if ((index = this.getSelectionIndex()) >= 0) {
                ((CCombo)this.combo).select(index);
            }
        }
        if (this.editHandler != null) {
            Button btn = new Button(subC, 0);
            btn.setImage(ImageUtil.getBitmapImage("img/icon_edit16x16.png", CallbackField.class));
            btn.setToolTipText("Edit");
            btn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DropdownField.this.editHandler.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (this.allowResetNull) {
            Button btn = new Button(subC, 0);
            btn.setImage(ImageUtil.getBitmapImage("img/cancel.png", CallbackField.class));
            btn.setToolTipText("Reset");
            btn.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    DropdownField.this.setValue(null);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        return this.combo;
    }

    public int getSelectionIndex() {
        if (this.mValues == null) {
            return -1;
        }
        int i = 0;
        T[] TArray = this.mValues;
        int n = this.mValues.length;
        int n2 = 0;
        while (n2 < n) {
            T next = TArray[n2];
            if (this.mValue == null && next == null) {
                return i;
            }
            if (this.mValue == null || next == null) {
                ++i;
            } else {
                if (next.equals(this.mValue)) {
                    return i;
                }
                ++i;
            }
            ++n2;
        }
        return -1;
    }

    public String[] getEnumsLabels() {
        return this.mLabels;
    }

    public T[] getEnums() {
        return this.mValues;
    }

    public void setNative(boolean isNative) {
        this.isNative = isNative;
    }

    @Override
    protected void doEnable(boolean value) {
        super.doEnable(value);
        if (this.label != null) {
            SwtUtil.enableWidget((Control)this.label, value, true);
        }
    }
}

