/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.edgemind.ibee.swt.core.field.FieldConstants;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class FieldData<T> {
    boolean enabled = true;
    boolean visible = true;
    protected Object mLabelLayout;
    protected Object mFieldLayout;
    private List<IModifiedListener<T>> mListener = new ArrayList<IModifiedListener<T>>();
    private List<FieldChecker<T>> mFieldChecker = null;
    public String mKey;
    protected int mColSpan = 1;
    protected boolean mIsCheckable = false;
    protected boolean mIsChecked = false;
    public String mLabel = "";
    private String unit = "";
    private String defaultValue = "";
    private String emptyStringValue = "";
    private String description = "";
    public T mValue = null;
    public int mRows = 2;
    public Control mControl;
    public Composite keyComposite;
    public Composite valueComposite;
    public Button checkableButton;
    public Integer fieldStyle;
    private List<Consumer<FieldData<T>>> onShownHandler;

    public abstract void updateUi();

    public Control getTextField() {
        return this.mControl;
    }

    public FieldData() {
    }

    public Object getFieldLayout() {
        return this.mFieldLayout;
    }

    public Object getLabelLayout() {
        return this.mLabelLayout;
    }

    public void setDescriptionLayout(Object layout) {
        this.mLabelLayout = layout;
    }

    public void setFieldLayout(Object layout) {
        this.mFieldLayout = layout;
    }

    public void addModifiedListener(IModifiedListener<T> l) {
        this.mListener.add(l);
    }

    public String getKey() {
        return this.mKey;
    }

    public T getValue() {
        return this.mValue;
    }

    public String getStringValue() {
        if (this.mValue == null) {
            return null;
        }
        return this.mValue.toString();
    }

    public String getEmptyStringValue() {
        return this.emptyStringValue;
    }

    public void setEmptyStringValue(String emptyStringValue) {
        this.emptyStringValue = emptyStringValue;
    }

    public boolean isEmpty() {
        return this.mValue == null || this.mValue.toString().trim().equalsIgnoreCase("");
    }

    public int getColSpan() {
        return this.mColSpan;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public Control getControl() {
        return this.mControl;
    }

    public Button getCheckableButton() {
        return this.checkableButton;
    }

    public FieldData<T> setValue(T value) {
        if (this.mValue == null && value == null) {
            return this;
        }
        if (this.mValue != null && value != null && this.mValue.equals(value)) {
            return this;
        }
        this.mValue = value;
        this.fireModified();
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.updateUi();
        }
        return this;
    }

    public void setLabel(String label) {
        this.mLabel = label;
    }

    public void setControl(Control control) {
        this.mControl = control;
    }

    public List<FieldChecker<T>> getFieldChecker() {
        if (this.mFieldChecker == null) {
            return new ArrayList<FieldChecker<T>>();
        }
        return this.mFieldChecker;
    }

    public void addFieldChecker(FieldChecker<T> checker) {
        if (this.mFieldChecker == null) {
            this.mFieldChecker = new ArrayList<FieldChecker<T>>();
        }
        this.mFieldChecker.add(checker);
    }

    public FieldData(String key, String label, T initValue) {
        this.mKey = key;
        this.mLabel = label;
        this.mValue = initValue;
    }

    public void addNoEmptyFieldChecker() {
        this.addFieldChecker(new FieldChecker<T>(){

            @Override
            public String getErrorMsg(FieldData<T> field) {
                if (FieldData.this.mValue instanceof String ? ((String)FieldData.this.mValue).trim().length() > 0 : FieldData.this.mValue != null) {
                    return null;
                }
                return "Value must not be empty";
            }
        });
    }

    public boolean isValid() {
        return this.getErrorMsg() == null;
    }

    public String getErrorMsg() {
        List<FieldChecker<T>> fieldChecker = this.getFieldChecker();
        StringBuilder problemReport = new StringBuilder();
        boolean ok = true;
        for (FieldChecker<T> checker : fieldChecker) {
            String msg = checker.getErrorMsg(this);
            if (msg == null) continue;
            ok = false;
            problemReport.append(msg);
            problemReport.append("\n");
        }
        if (ok) {
            return null;
        }
        return problemReport.toString();
    }

    public boolean getIsCheckable() {
        return this.mIsCheckable;
    }

    public void setIsCheckbable(boolean v) {
        this.mIsCheckable = v;
    }

    public boolean getIsChecked() {
        return this.mIsChecked;
    }

    public void setIsCheckbed(boolean v) {
        this.mIsChecked = v;
    }

    public String getUnit() {
        return this.unit;
    }

    public FieldData<T> setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public FieldData<T> setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public FieldData<T> setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Integer getFieldStyle() {
        return this.fieldStyle;
    }

    public void setFieldStyle(int style) {
        this.fieldStyle = this.fieldStyle != null ? Integer.valueOf(this.fieldStyle | style) : Integer.valueOf(style);
    }

    public final Control create(Composite parent) {
        this.keyComposite = parent;
        this.valueComposite = parent;
        if (this.mIsCheckable) {
            this.keyComposite = new Composite(parent, 0);
            this.keyComposite.setLayout((Layout)new GridLayout(2, false));
            this.keyComposite.setLayoutData((Object)new GridData(1808));
            this.checkableButton = new Button(this.keyComposite, 32);
            this.checkableButton.setSelection(this.mIsChecked);
            this.checkableButton.setLayoutData((Object)new GridData(1));
            this.checkableButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FieldData.this.mIsChecked = FieldData.this.checkableButton.getSelection();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        Control control = this.createContents(parent);
        return control;
    }

    public abstract Control createContents(Composite var1);

    public void setEnabled(boolean value) {
        this.enabled = value;
        this.doEnable(this.enabled);
    }

    public void setVisible(boolean value) {
        this.visible = value;
        this.doVisible(this.visible);
    }

    protected void doEnable(boolean value) {
        if (this.getControl() != null) {
            SwtUtil.enableWidget(this.getControl(), value, true);
        }
    }

    protected void doVisible(boolean v) {
        if (this.getControl() == null) {
            return;
        }
        this.getControl().setVisible(v);
    }

    protected void fireModified() {
        for (IModifiedListener<T> l : this.mListener) {
            l.modified(this.mValue);
        }
    }

    void triggerOnShown() {
        if (this.onShownHandler != null) {
            for (Consumer<FieldData<FieldData>> consumer : this.onShownHandler) {
                consumer.accept(this);
            }
        }
    }

    public void onShown(Consumer<FieldData<T>> consumer) {
        if (this.onShownHandler == null) {
            this.onShownHandler = new ArrayList<Consumer<FieldData<T>>>();
        }
        this.onShownHandler.add(consumer);
    }

    protected String resizeText(String text) {
        if (text.length() >= FieldConstants.fieldLengthLimit) {
            text = String.format("%s...", text.substring(0, FieldConstants.fieldLengthLimit - 3));
        }
        return text;
    }

    public static interface FieldChecker<T> {
        public String getErrorMsg(FieldData<T> var1);
    }

    public static interface IModifiedListener<T> {
        public void modified(T var1);
    }

    public static interface IOnOp<T> {
        public void modified(T var1);
    }
}

