/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import java.util.Arrays;
import java.util.Collection;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class FieldSyntaxHighlighter {
    private Collection<FieldData<?>> fields;
    private net.edgemind.ibee.core.diagram.Color color = net.edgemind.ibee.core.diagram.Color.YELLOW;

    public FieldSyntaxHighlighter(FieldData<?> field) {
        this(Arrays.asList(field));
    }

    public FieldSyntaxHighlighter(Collection<FieldData<?>> fields) {
        this.fields = fields;
        for (FieldData<?> field : fields) {
            field.addModifiedListener(new FieldData.IModifiedListener(){

                public void modified(Object value) {
                    FieldSyntaxHighlighter.this.update();
                }
            });
            field.onShown(f -> this.update());
        }
        this.update();
    }

    public void update() {
        for (FieldData<?> field : this.fields) {
            Control control = field.getControl();
            if (control == null) continue;
            if (field.isValid()) {
                control.setBackground(null);
                continue;
            }
            Color swtColor = SwtUtil.toSwtColor(this.color);
            control.setBackground(swtColor);
        }
    }

    public void setColor(net.edgemind.ibee.core.diagram.Color color) {
        this.color = color;
    }
}

