/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import java.io.File;
import net.edgemind.ibee.swt.core.field.CallbackField;
import net.edgemind.ibee.swt.core.field.FileExistsChecker;
import net.edgemind.ibee.swt.core.field.FileExtensionChecker;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FileField
extends CallbackField<String> {
    private boolean confirmOverwrite = true;
    private boolean mWriteMode = false;
    private boolean mIsFolder = false;
    private String[] automaticFileExtensions = null;
    private String[] extensionsLabels = null;
    private File defaultPromptDir = null;

    public void confirmOverwrite(boolean value) {
        this.confirmOverwrite = value;
    }

    public FileField(String key, String label, File defaultValue, boolean isFolder, boolean writeMode) {
        this(key, label, defaultValue != null ? defaultValue.getAbsolutePath() : "", isFolder, writeMode);
    }

    public FileField(String key, String label, String defaultValue, boolean isFolder, boolean writeMode) {
        super(key, label, defaultValue, null);
        this.mWriteMode = writeMode;
        this.mIsFolder = isFolder;
        super.setEditable(true);
    }

    public boolean getWriteMode() {
        return this.mWriteMode;
    }

    public boolean getIsFolder() {
        return this.mIsFolder;
    }

    public void setAutomaticFileExtension(String[] extensions) {
        this.automaticFileExtensions = extensions;
    }

    public void setAutomaticFileExtension(String[] extensions, String[] labels) {
        this.automaticFileExtensions = extensions;
        this.extensionsLabels = labels;
    }

    public void setAutomaticFileExtension(String extension) {
        if (extension != null) {
            this.automaticFileExtensions = new String[1];
            this.automaticFileExtensions[0] = extension;
        } else {
            this.automaticFileExtensions = null;
        }
    }

    public void setAutomaticFileExtension(String extension, String label) {
        if (extension != null) {
            this.automaticFileExtensions = new String[1];
            this.automaticFileExtensions[0] = extension;
            if (label != null) {
                this.extensionsLabels = new String[1];
                this.extensionsLabels[0] = label;
            }
        } else {
            this.automaticFileExtensions = null;
        }
    }

    public void setDefaultPromptDir(File dir) {
        this.defaultPromptDir = dir;
    }

    private String getPrePromptValue() {
        String v = (String)this.getValue();
        if (v != null && v.length() > 0) {
            File test = new File(v);
            if (test.exists()) {
                return v;
            }
            File parentTest = test.getParentFile();
            if (parentTest != null && parentTest.exists() && parentTest.isDirectory()) {
                return v;
            }
        }
        if (this.defaultPromptDir == null) {
            return null;
        }
        return this.defaultPromptDir.getAbsolutePath();
    }

    public File getFile() {
        String value = (String)this.getValue();
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        return new File(value);
    }

    @Override
    public boolean isValid() {
        return this.getErrorMsg() == null;
    }

    public void addFileExistsChecker() {
        this.addFieldChecker(new FileExistsChecker());
    }

    public void addFileExtensionChecker(String extension) {
        this.addFieldChecker(new FileExtensionChecker(extension));
    }

    @Override
    public void updateUi() {
        if (this.isEmpty()) {
            if (!((Text)this.mControl).getText().equals(this.getEmptyStringValue())) {
                ((Text)this.mControl).setText(this.getEmptyStringValue());
            }
        } else if (!((Text)this.mControl).getText().equals(this.mValue)) {
            ((Text)this.mControl).setText((String)this.mValue);
        }
    }

    @Override
    public SelectionListener createSelectionListener(final Composite parent) {
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = null;
                String dlgTitle = "Select " + FileField.this.getLabel();
                fileName = FileField.this.getIsFolder() ? (FileField.this.getWriteMode() ? SwtUtil.promptDirPathSave(dlgTitle, FileField.this.getPrePromptValue(), parent.getShell()) : SwtUtil.promptDirPathRead(dlgTitle, FileField.this.getPrePromptValue(), parent.getShell())) : (FileField.this.getWriteMode() ? SwtUtil.promptFilePathSave(dlgTitle, FileField.this.getPrePromptValue(), parent.getShell(), FileField.this.confirmOverwrite, FileField.this.automaticFileExtensions, FileField.this.extensionsLabels) : SwtUtil.promptFilePathRead(dlgTitle, FileField.this.getPrePromptValue(), parent.getShell(), FileField.this.automaticFileExtensions, FileField.this.extensionsLabels));
                if (fileName != null && fileName.length() > 0) {
                    if (FileUtil.getExtension((String)fileName) == null && FileField.this.automaticFileExtensions != null && FileField.this.automaticFileExtensions.length > 0) {
                        String combinedExt = FileField.this.automaticFileExtensions[0];
                        String ext = combinedExt.split(";")[0];
                        fileName = FileUtil.replaceExtension((String)fileName, (String)ext);
                    }
                    FileField.this.setValue(fileName);
                    FileField.this.updateUi();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        return listener;
    }
}

