/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.StringField;
import net.edgemind.ibee.util.string.StringUtil;

public class IntegerField
extends StringField {
    public IntegerField(String key, String label, String defaultValue) {
        super(key, label, defaultValue);
        this.addFieldChecker(new FieldData.FieldChecker<String>(){

            @Override
            public String getErrorMsg(FieldData<String> field) {
                String value = field.getValue();
                if (value.equals("")) {
                    return null;
                }
                try {
                    new Integer(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return "Not an integer";
                }
                return null;
            }
        });
    }

    public IntegerField(String key, String label, Integer defaultValue) {
        this(key, label, StringUtil.toString((Integer)defaultValue, (String)""));
    }

    public void setIntValue(Integer value) {
        this.setValue(StringUtil.toString((Integer)value, (String)""));
    }

    public Integer getIntValue() {
        String value = (String)this.getValue();
        try {
            Integer i = new Integer(value);
            return i;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Integer getIntValue(int def) {
        return StringUtil.toInt((String)((String)this.mValue), (Integer)def);
    }
}

