/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class StringMultiLineField
extends FieldData<String> {
    private boolean readOnly = false;
    private int style = 2048;
    private Label label;
    private boolean useDefaultLayout = true;

    public StringMultiLineField(String key, String label, String initValue) {
        super(key, label, initValue);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setUseDefaultLayout(boolean useDefaultLayout) {
        this.useDefaultLayout = useDefaultLayout;
    }

    public void addStyle(int style) {
        this.style |= style;
    }

    @Override
    public Object getFieldLayout() {
        if (this.mFieldLayout == null && this.useDefaultLayout) {
            return this.getDefaultLayout();
        }
        return this.mFieldLayout;
    }

    public Object getDefaultLayout() {
        GridData data = new GridData(1808);
        data.widthHint = 300;
        data.heightHint = 200;
        return data;
    }

    @Override
    public void updateUi() {
        if (this.isEmpty()) {
            if (!((StyledText)this.mControl).getText().equals(this.getEmptyStringValue())) {
                ((StyledText)this.mControl).setText(this.getEmptyStringValue());
            }
        } else if (!((StyledText)this.mControl).getText().equals(this.mValue)) {
            ((StyledText)this.mControl).setText((String)this.mValue);
        }
    }

    @Override
    public Control createContents(Composite parent) {
        this.label = new Label(this.keyComposite, 0);
        this.label.setText(this.mLabel + ": ");
        if (this.mLabelLayout != null) {
            this.label.setLayoutData(this.mLabelLayout);
        }
        if (this.readOnly) {
            this.style |= 8;
        }
        this.style = this.style | 2 | 0x40;
        this.style = this.style | 0x200 | 0x100;
        final StyledText text = new StyledText(this.valueComposite, this.style);
        text.setLayoutData(this.mFieldLayout);
        if (this.mValue != null) {
            text.setText((String)this.mValue);
        }
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                text.setSelection(0);
            }
        });
        text.addModifyListener(e -> {
            FieldData<String> fieldData = this.setValue(text.getText());
        });
        return text;
    }

    @Override
    protected void doEnable(boolean value) {
        super.doEnable(value);
        if (this.label != null) {
            SwtUtil.enableWidget((Control)this.label, value, true);
        }
    }
}

