/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SwtFieldCreator {
    private int mMinWidth = 150;
    private Map<String, FieldData<?>> fields = new LinkedHashMap();
    private boolean printDefaultValue = false;
    private boolean printUnit = false;
    private boolean showDescription = false;

    public boolean getPrintUnit() {
        return this.printUnit;
    }

    public SwtFieldCreator setPrintUnit(boolean printUnit) {
        this.printUnit = printUnit;
        return this;
    }

    public boolean getPrintDefaultValue() {
        return this.printDefaultValue;
    }

    public boolean getShowDescription() {
        return this.showDescription;
    }

    public SwtFieldCreator setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
        return this;
    }

    public void clear() {
        this.fields.clear();
    }

    public int getRequiredColumns() {
        int cols = 2;
        if (this.printUnit) {
            ++cols;
        }
        if (this.showDescription) {
            ++cols;
        }
        return cols;
    }

    public SwtFieldCreator setPrintDefaultValue(boolean printDefaultValue) {
        this.printDefaultValue = printDefaultValue;
        return this;
    }

    public void createFields(List<FieldData<?>> fields, Composite parent) {
        for (FieldData<?> field : fields) {
            this.createField(field, parent);
        }
    }

    public void createField(FieldData<?> field, Composite parent) {
        this.createField(field, parent, 2, 768);
    }

    public void createField(FieldData<?> field, Composite parent, int columns, int style) {
        Object layout;
        Object fieldLayout = field.getFieldLayout();
        if (this.printDefaultValue) {
            Object defaultValue = field.getDefaultValue();
            defaultValue = defaultValue == null || ((String)defaultValue).isEmpty() ? "" : " [" + (String)defaultValue + "]";
            field.setLabel(field.getLabel() + (String)defaultValue);
        }
        Control control = field.create(parent);
        if (fieldLayout != null) {
            layout = fieldLayout;
        } else {
            GridData data = new GridData(style);
            data.minimumWidth = this.mMinWidth;
            data.horizontalSpan = field.getColSpan();
            layout = data;
        }
        control.setLayoutData(layout);
        if (this.printUnit) {
            String unit = field.getUnit();
            if (unit == null || unit.isEmpty()) {
                unit = "";
            }
            new Label(parent, 0).setText(unit);
        }
        String desc = field.getDescription().trim();
        if (this.showDescription) {
            if (desc != null && desc.length() > 0) {
                Button btnInfo = new Button(parent, 2);
                btnInfo.setToolTipText(desc);
                btnInfo.setImage(ImageUtil.getImage("img/info.png", SwtFieldCreator.class));
                btnInfo.addListener(13, e -> SwtUtil.showInfo(field.getLabel(), desc, btnInfo.getShell()));
            } else {
                new Label(parent, 0);
            }
        }
        int i = 0;
        while (i < columns - field.mRows) {
            new Label(parent, 8);
            ++i;
        }
        field.mControl = control;
        if (!field.enabled) {
            field.setEnabled(false);
        }
        field.updateUi();
        this.fields.put(field.mKey, field);
        field.triggerOnShown();
    }

    public void clearFields() {
        this.fields.clear();
    }

    public boolean hasField(String key) {
        return this.fields.get(key) != null;
    }

    public <T> FieldData<T> getField(String key) {
        return this.fields.get(key);
    }

    public List<FieldData<?>> getFields() {
        return new ArrayList(this.fields.values());
    }

    public String getName(String key) {
        FieldData field = this.getField(key);
        if (field == null) {
            return null;
        }
        return field.mLabel;
    }

    public <T> T getValue(String key, Class<T> clazz) {
        return this.getValue(key, (T)null);
    }

    public <T> T getValue(String key, Class<T> clazz, T def) {
        return this.getValue(key, def);
    }

    public <T> T getValue(String key) {
        return this.getValue(key, (T)null);
    }

    public <T> T getValue(String key, T def) {
        FieldData<T> field = this.getField(key);
        if (field == null) {
            return def;
        }
        return field.mValue;
    }

    public <T> String getStringValue(String key) {
        FieldData<T> field = this.getField(key);
        if (field == null) {
            return null;
        }
        return field.getStringValue();
    }

    public boolean getIsChecked(String key) {
        return this.getStringValue(key).equalsIgnoreCase("true");
    }

    public void setMinWidth(int minWidth) {
        this.mMinWidth = minWidth;
    }

    public String getErrorMsg() {
        StringBuilder builder = new StringBuilder();
        boolean ok = true;
        for (String key : this.fields.keySet()) {
            FieldData<?> field = this.fields.get(key);
            String msg = field.getErrorMsg();
            if (msg == null) continue;
            builder.append("Field '" + field.getLabel() + "': " + msg);
            ok = false;
        }
        if (ok) {
            return null;
        }
        return builder.toString();
    }
}

