/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.field.SwtFieldCreator;
import net.edgemind.ibee.swt.core.field.SwtFieldSet;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class SwtFieldCreatorMulti {
    private Map<String, SwtFieldCreator> fieldCreators = new HashMap<String, SwtFieldCreator>();
    private TabFolder tabFolder;

    public void createFields(SwtFieldSet fieldSet, Composite parent) {
        this.createFields(fieldSet.getFieldSet(), parent);
    }

    public void createFields(Map<String, List<FieldData<?>>> fields, Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        GridData data = new GridData(1808);
        this.tabFolder.setLayoutData((Object)data);
        for (String key : fields.keySet()) {
            this.createFields(key, fields.get(key));
        }
        this.tabFolder.setSelection(0);
    }

    public void createFields(String key, List<FieldData<?>> fields) {
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setText(key);
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        SwtFieldCreator creator = new SwtFieldCreator();
        creator.setMinWidth(300);
        this.fieldCreators.put(key, creator);
        this.createFields(creator, composite, fields);
        item.setControl((Control)composite);
    }

    private void createFields(SwtFieldCreator creator, Composite parent, List<FieldData<?>> fields) {
        for (FieldData<?> field : fields) {
            creator.createField(field, parent);
        }
    }

    public List<FieldData<?>> getFields() {
        ArrayList allFields = new ArrayList();
        this.fieldCreators.values().forEach(creator -> {
            boolean bl = allFields.addAll(creator.getFields());
        });
        return allFields;
    }

    public Map<String, SwtFieldCreator> getFieldCreators() {
        return this.fieldCreators;
    }

    public String getSelectedTab() {
        return this.tabFolder.getItem(this.tabFolder.getSelectionIndex()).getText();
    }

    public <T> FieldData<T> getField(String key) {
        Optional<FieldData> optField = this.getFields().stream().filter(field -> field.getKey().equalsIgnoreCase(key)).findFirst();
        return optField.isPresent() ? optField.get() : null;
    }

    public <T> String getStringValue(String key) {
        FieldData<T> field = this.getField(key);
        if (field == null) {
            return null;
        }
        return field.getStringValue();
    }

    public <T> T getValue(String key, Class<T> clazz) {
        return this.getValue(key, (T)null);
    }

    public <T> T getValue(String key, Class<T> clazz, T def) {
        return this.getValue(key, def);
    }

    public <T> T getValue(String key) {
        return this.getValue(key, (T)null);
    }

    public <T> T getValue(String key, T def) {
        FieldData<T> field = this.getField(key);
        if (field == null) {
            return def;
        }
        return field.mValue;
    }
}

