/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.field;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.edgemind.ibee.swt.core.field.FieldData;

public class SwtFieldSet {
    private Map<String, List<FieldData<?>>> fieldSet = new LinkedHashMap();

    public Map<String, List<FieldData<?>>> getFieldSet() {
        return this.fieldSet;
    }

    public List<FieldData<?>> getFields(String key, boolean create) {
        List<FieldData<?>> fields = this.fieldSet.get(key);
        if (fields == null && create) {
            fields = new ArrayList();
            this.fieldSet.put(key, fields);
        }
        return fields;
    }

    public List<String> getKeys() {
        return this.fieldSet.keySet().stream().collect(Collectors.toList());
    }

    public void addFields(String key, List<FieldData<?>> fields) {
        List<FieldData<?>> sectionFields = this.getFields(key, true);
        sectionFields.addAll(fields);
    }

    public void setFields(String key, List<FieldData<?>> fields) {
        this.fieldSet.put(key, fields);
    }

    public List<FieldData<?>> getAllFields() {
        ArrayList allFields = new ArrayList();
        this.fieldSet.values().forEach(fields -> {
            boolean bl = allFields.addAll((Collection<FieldData<?>>)fields);
        });
        return allFields;
    }

    public <T> FieldData<T> getField(String key) {
        Optional<FieldData> optField = this.getAllFields().stream().filter(field -> field.getKey().equalsIgnoreCase(key)).findFirst();
        return optField.isPresent() ? optField.get() : null;
    }

    public <T> String getStringValue(String key) {
        FieldData<T> field = this.getField(key);
        if (field == null) {
            return null;
        }
        return field.getStringValue();
    }

    public <T> T getValue(String key, Class<T> clazz) {
        return this.getValue(key, (T)null);
    }

    public <T> T getValue(String key, Class<T> clazz, T def) {
        return this.getValue(key, def);
    }

    public <T> T getValue(String key) {
        return this.getValue(key, (T)null);
    }

    public <T> T getValue(String key, T def) {
        FieldData<T> field = this.getField(key);
        if (field == null) {
            return def;
        }
        return field.mValue;
    }
}

