/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.handler;

import net.edgemind.ibee.core.command.ICommand;
import net.edgemind.ibee.core.command.ICommandHandler;
import net.edgemind.ibee.swt.core.renderer.SWTMenuRenderer;
import net.edgemind.ibee.ui.menu.IMenu;
import net.edgemind.ibee.ui.menu.OpenPopupCommand;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SwtOpenPopupHandler
implements ICommandHandler {
    private static final long serialVersionUID = 1L;

    public void execute(ICommand command) {
        Control control;
        ToolItem toolItem;
        OpenPopupCommand cmd = (OpenPopupCommand)command;
        IMenu menu = cmd.getMenu();
        if (menu == null) {
            return;
        }
        Object object = cmd.getUiParent();
        double x = cmd.getX();
        double y = cmd.getY();
        if (object instanceof ToolItem) {
            toolItem = (ToolItem)object;
            control = toolItem.getParent();
        } else {
            control = (Control)object;
        }
        if (object instanceof ToolItem) {
            toolItem = (ToolItem)object;
            Point offset = this.getOffset(toolItem.getParent(), toolItem);
            x = offset.x;
            y = offset.y;
        }
        Menu swtMenu = new Menu(control);
        SWTMenuRenderer renderer = new SWTMenuRenderer(swtMenu);
        renderer.renderMenu(menu, x, y);
        Point p = control.toDisplay((int)x, (int)y);
        swtMenu.setLocation(p.x, p.y);
        swtMenu.setVisible(true);
        while (!swtMenu.isDisposed() && swtMenu.isVisible()) {
            if (control.getDisplay().readAndDispatch()) continue;
            control.getDisplay().sleep();
        }
        swtMenu.dispose();
    }

    private Point getOffset(ToolBar toolBar, ToolItem toolItem) {
        int width = 0;
        int height = 0;
        ToolItem[] toolItemArray = toolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            if (item == toolItem) break;
            width += item.getWidth();
            ++n2;
        }
        height = toolBar.getBounds().height;
        return new Point(width, height);
    }
}

