/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.image;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.swt.core.image.SVGImageUtil;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.FrameworkUtil;

public class ImageUtil {
    public static String sDevPath = "../fr.edf.andromeda.core/";
    public static Map<String, Image> imageCache = new HashMap<String, Image>();

    public static Image addOverlay(Image img1, Image img2, int destX, int destY, int destWidth, int destHeight) {
        Image imageFinal = new Image((Device)Display.getCurrent(), img1.getImageData().width, img1.getImageData().height);
        GC gc = new GC((Drawable)imageFinal, 262144);
        gc.drawImage(img1, 0, 0, img1.getImageData().width, img1.getImageData().height, 0, 0, img1.getImageData().width, img1.getImageData().height);
        gc.drawImage(img2, 0, 0, img2.getImageData().width, img2.getImageData().height, destX, destY, destWidth, destHeight);
        gc.dispose();
        return imageFinal;
    }

    public static ImageData flip(ImageData srcData, boolean vertical) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = srcData.width * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                if (vertical) {
                    destX = srcX;
                    destY = srcData.height - srcY - 1;
                } else {
                    destX = srcData.width - srcX - 1;
                    destY = srcY;
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(srcData.width, srcData.height, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }

    public static ImageData rotate(ImageData srcData, int direction) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = direction == 1024 ? srcData.width * bytesPerPixel : srcData.height * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        int width = 0;
        int height = 0;
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                switch (direction) {
                    case 16384: {
                        destX = srcY;
                        destY = srcData.width - srcX - 1;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 131072: {
                        destX = srcData.height - srcY - 1;
                        destY = srcX;
                        width = srcData.height;
                        height = srcData.width;
                        break;
                    }
                    case 1024: {
                        destX = srcData.width - srcX - 1;
                        destY = srcData.height - srcY - 1;
                        width = srcData.width;
                        height = srcData.height;
                    }
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(width, height, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }

    public static Image getBitmapImage(String path, Class pluginClass) {
        return ImageUtil.getNormalImage(path, pluginClass, -1, -1);
    }

    public static Image getImage(String path) {
        return ImageUtil.getImage(path, null);
    }

    public static Image getImage(String path, String bundle) {
        if (path == null || bundle == null) {
            return null;
        }
        Image image = null;
        String pathCached = bundle + "/" + path;
        if (imageCache.containsKey(pathCached)) {
            return imageCache.get(pathCached);
        }
        try {
            URL url = new URL("platform:/plugin/" + bundle + "/" + path);
            InputStream inputStream = url.openConnection().getInputStream();
            if (inputStream != null) {
                image = ImageUtil.getImage(inputStream);
            }
        }
        catch (Exception e) {
            LogUtil.error((Throwable)e);
        }
        imageCache.put(pathCached, image);
        return image;
    }

    public static Image getImage(String path, Class pluginClass, int width, int height) {
        if (path == null) {
            return null;
        }
        if (pluginClass == null) {
            pluginClass = ImageUtil.class;
        }
        if (SVGImageUtil.isSvgImage(path)) {
            return SVGImageUtil.rasterize(path, pluginClass, width, height);
        }
        return ImageUtil.getNormalImage(path, pluginClass, width, height);
    }

    public static Image getImage(String path, Class pluginClass) {
        if (path == null) {
            return null;
        }
        if (pluginClass == null) {
            pluginClass = ImageUtil.class;
        }
        return ImageUtil.getNormalImage(path, pluginClass);
    }

    public static Image getImage(InputStream stream) {
        if (stream == null) {
            return null;
        }
        Image image = new Image((Device)Display.getCurrent(), stream);
        ImageData imgData = image.getImageData();
        int i = imgData.getTransparencyType();
        if (i == 0) {
            int w = 0;
            while (w < imgData.width) {
                int h = 0;
                while (h < imgData.height) {
                    if (imgData.getPixel(w, h) == 0xFFFFFF) {
                        imgData.setAlpha(w, h, 0);
                    } else {
                        imgData.setAlpha(w, h, 255);
                    }
                    ++h;
                }
                ++w;
            }
            image.dispose();
            image = new Image((Device)Display.getCurrent(), imgData);
        }
        return image;
    }

    public static InputStream getImageStream(String path, Class pluginClass) throws IOException {
        boolean isFile = false;
        if (((String)path).startsWith("file://")) {
            isFile = true;
            path = ((String)path).substring("file://".length());
        }
        InputStream imgStream = null;
        if (isFile) {
            try {
                imgStream = FileUtil.openInputStream((File)new File((String)path));
            }
            catch (FileNotFoundException fileNotFoundException) {
                imgStream = null;
            }
        } else if (pluginClass != null) {
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            if ((imgStream = pluginClass.getResourceAsStream((String)path)) == null) {
                try {
                    imgStream = FileUtil.openInputStream((File)new File(sDevPath + (String)path));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        imgStream = FileUtil.openInputStream((File)new File((String)path));
                    }
                    catch (FileNotFoundException e2) {
                        LogUtil.error((Throwable)e2);
                    }
                }
            }
        }
        return imgStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getNormalImage(String path, Class pluginClass) {
        Object key = path;
        if (pluginClass != null) {
            key = FrameworkUtil.getBundle((Class)pluginClass).getSymbolicName() + ":" + (String)key;
        }
        if (imageCache.containsKey(key)) {
            return imageCache.get(key);
        }
        Image image = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream imgStream = ImageUtil.getImageStream(path, pluginClass);){
                if (imgStream == null) {
                    LogUtil.warning((String)("Bitmap image " + (String)key + " not found"));
                    imageCache.put((String)key, null);
                    return null;
                }
                image = ImageUtil.getImage(imgStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            LogUtil.log((Throwable)e);
        }
        imageCache.put((String)key, image);
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getNormalImage(String path, Class pluginClass, int width, int height) {
        String key = path + "+" + width + "x" + height + "y";
        if (pluginClass != null) {
            key = FrameworkUtil.getBundle((Class)pluginClass).getSymbolicName() + ":" + key;
        }
        if (imageCache.containsKey(key)) {
            return imageCache.get(key);
        }
        Image image = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream imgStream = ImageUtil.getImageStream(path, pluginClass);){
                if (imgStream == null) {
                    LogUtil.warning((String)("Bitmap image " + key + " not found"));
                    imageCache.put(key, null);
                    return null;
                }
                ImageData newData = new ImageData(imgStream);
                if (width > 0 && height > 0) {
                    newData = newData.scaledTo(width, height);
                }
                image = new Image((Device)Display.getCurrent(), newData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            LogUtil.log((Throwable)e);
        }
        imageCache.put(key, image);
        return image;
    }

    public static Image getCachedImage(String path) {
        return imageCache.get(path);
    }

    public static void putCachedImage(Image img, String path) {
        imageCache.put(path, img);
    }

    public static void writePngImage(Image image, File file) throws IOException {
        FileUtil.createDir((File)file.getParentFile());
        ImageLoader saver = new ImageLoader();
        saver.data = new ImageData[]{image.getImageData()};
        saver.save(file.getAbsolutePath(), 5);
    }
}

