/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.image;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.edgemind.ibee.core.diagram.Diagram;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.core.diagram.util.DiagramGCUtil;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.swt.core.renderer.SWTDiagramRenderer;
import net.edgemind.ibee.util.file.FileUtil;
import net.edgemind.ibee.util.math.Frame;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class PngDiagramPrinter {
    private Point minimumSize;
    private double margin = 15.0;
    static List<String> test = new ArrayList<String>();

    public void setMinimumSize(Point size) {
        this.minimumSize = size;
    }

    public void setMargin(double value) {
        this.margin = value;
    }

    public void printDiagram(Diagram diagram, File file) {
        if (diagram == null) {
            return;
        }
        this.getDisplay().syncExec(() -> {
            Image image = this.printIntoImage(diagram);
            this.printToFile(image, file);
            this.cleanup(image);
        });
    }

    private void printToFile(Image image, File file) {
        ImageLoader loader = new ImageLoader();
        Object filePath = file.getAbsolutePath();
        if (!((String)filePath).toLowerCase().endsWith(".png")) {
            filePath = (String)filePath + ".png";
        }
        loader.data = new ImageData[]{image.getImageData()};
        try {
            FileUtil.createDir((String)FileUtil.extractFileDir((String)filePath));
        }
        catch (IOException e) {
            throw new IbeeException((Throwable)e);
        }
        loader.save((String)filePath, 5);
    }

    private Image printIntoImage(Diagram diagram) {
        Frame diagramFrame = diagram.getSize(true);
        diagramFrame.setX(diagramFrame.getX() - this.margin);
        diagramFrame.setY(diagramFrame.getY() - this.margin);
        diagramFrame.setWidth(diagramFrame.getWidth() + 2.0 * this.margin);
        diagramFrame.setHeight(diagramFrame.getHeight() + 2.0 * this.margin);
        double imgWidth = diagramFrame.getWidth();
        double imgHeight = diagramFrame.getHeight();
        if (this.minimumSize != null) {
            if (this.minimumSize.getX() > imgWidth) {
                imgWidth = this.minimumSize.getX();
            }
            if (this.minimumSize.getY() > imgHeight) {
                imgHeight = this.minimumSize.getY();
            }
        }
        SWTDiagramRenderer renderer = new SWTDiagramRenderer();
        renderer.init(new Rectangle(0, 0, (int)imgWidth, (int)imgHeight));
        renderer.setZoomX(1.0);
        renderer.setZoomY(1.0);
        renderer.translateToCenterX(false);
        renderer.translateToCenterY(false);
        renderer.setTranslate(diagramFrame.getX(), diagramFrame.getY());
        renderer.repaintDiagram(diagram);
        Display display = this.getDisplay();
        Image diagramImage = new Image((Device)display, (int)imgWidth, (int)imgHeight);
        GC gc = new GC((Drawable)diagramImage);
        DiagramGCUtil.applyDefaultOption((GC)gc);
        renderer.paintDiagram(gc);
        gc.dispose();
        return diagramImage;
    }

    private void cleanup(Image image) {
        image.dispose();
    }

    private Display getDisplay() {
        Display display = Display.getDefault();
        if (display == null) {
            display = new Display();
        }
        return display;
    }
}

