/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.image;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.edgemind.ibee.core.log.LogUtil;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;

public class SVGImageUtil {
    public static Map<String, Document> inputs = new HashMap<String, Document>();
    public static Map<String, Image> images = new HashMap<String, Image>();

    public static boolean isSvgImage(String imgPath) {
        return imgPath.toLowerCase().endsWith("svg");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image rasterize(String svgFile, Class pluginClass, int width, int height) {
        Image newImage;
        String key;
        block14: {
            key = svgFile + width + "x" + height;
            if (pluginClass != null) {
                key = FrameworkUtil.getBundle((Class)pluginClass).getSymbolicName() + ":" + key;
            }
            if (images.containsKey(key)) {
                return images.get(key);
            }
            Document doc = inputs.get(svgFile);
            newImage = null;
            if (doc == null) {
                try {
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (InputStream imgStream = ImageUtil.getImageStream(svgFile, pluginClass);){
                        if (imgStream == null) {
                            LogUtil.warning((String)("SVG image " + key + " not found"));
                            return null;
                        }
                        TranscoderInput input = new TranscoderInput(imgStream);
                        newImage = SVGImageUtil.rasterize(width, height, input);
                        break block14;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LogUtil.log((Throwable)e);
                    return null;
                }
            }
            TranscoderInput input = new TranscoderInput(doc);
            newImage = SVGImageUtil.rasterize(width, height, input);
        }
        if (newImage == null) return newImage;
        images.put(key, newImage);
        ImageTagRegistry.getRegistry().flushCache();
        return newImage;
    }

    private static Image rasterize(int width, int height, TranscoderInput input) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            TranscoderOutput transcoderOutput = new TranscoderOutput((OutputStream)output);
            PNGTranscoder transcoder = null;
            String type = "png";
            if (type.equalsIgnoreCase("png")) {
                transcoder = new PNGTranscoder(){

                    protected ImageRenderer createRenderer() {
                        ImageRenderer r = super.createRenderer();
                        RenderingHints rh = r.getRenderingHints();
                        rh.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
                        rh.add(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
                        rh.add(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
                        rh.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
                        rh.add(new RenderingHints(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE));
                        rh.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
                        rh.add(new RenderingHints(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE));
                        rh.add(new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON));
                        rh.add(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF));
                        r.setRenderingHints(rh);
                        return r;
                    }
                };
                transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, (Object)new Float(width));
                transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, (Object)new Float(height));
                transcoder.addTranscodingHint(PNGTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
            } else {
                transcoder = new JPEGTranscoder();
                Float jpegQuality = new Float(0.95);
                transcoder.addTranscodingHint(ImageTranscoder.KEY_WIDTH, (Object)new Float(width));
                transcoder.addTranscodingHint(ImageTranscoder.KEY_HEIGHT, (Object)new Float(height));
                transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)jpegQuality);
            }
            try {
                transcoder.transcode(input, transcoderOutput);
            }
            catch (Exception e) {
                LogUtil.error((String)"SVG To Raster response transcode exception");
                e.printStackTrace();
                if (output != null) {
                    output.close();
                }
                throw new RuntimeException("SVG To Raster Filter Response Stream Exception", e);
            }
            Image image = null;
            if (output != null) {
                output.flush();
                image = new Image((Device)Display.getCurrent(), (InputStream)new ByteArrayInputStream(output.toByteArray()));
                output.close();
            }
            transcoderOutput = null;
            transcoder = null;
            Image newImage = SVGImageUtil.makeTransparent(image);
            image.dispose();
            return newImage;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.error((String)"Error in rendering png method");
            return null;
        }
    }

    private static Image makeTransparent(Image image) {
        ImageData imgData = image.getImageData();
        imgData.getTransparencyType();
        int d = imgData.alpha;
        int w = 0;
        while (w < imgData.width) {
            int h = 0;
            while (h < imgData.height) {
                if (imgData.getAlpha(w, h) == 0) {
                    System.out.println(d);
                }
                if (imgData.getPixel(w, h) == 0xFFFFFF) {
                    imgData.setAlpha(w, h, 0);
                } else {
                    imgData.setAlpha(w, h, 255);
                }
                ++h;
            }
            ++w;
        }
        image = new Image((Device)Display.getCurrent(), imgData);
        return image;
    }

    public static class MyTranscoder
    extends ImageTranscoder {
        BufferedImage image;

        public BufferedImage createImage(int w, int h) {
            this.image = new BufferedImage(w, h, 2);
            return this.image;
        }

        public void writeImage(BufferedImage image, TranscoderOutput out) throws TranscoderException {
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

