/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.panel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.edgemind.ibee.core.diagram.Point;
import net.edgemind.ibee.swt.core.cursor.SwtCursor;
import net.edgemind.ibee.swt.core.panel.SWTKeyCode;
import net.edgemind.ibee.swt.core.panel.SwtToolbarPanel;
import net.edgemind.ibee.swt.core.renderer.SWTDiagramRenderer;
import net.edgemind.ibee.swt.core.renderer.SWTMenuRenderer;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.ui.diagram.CURSOR;
import net.edgemind.ibee.ui.diagram.DiagramPanel;
import net.edgemind.ibee.ui.diagram.KeyCodes;
import net.edgemind.ibee.ui.diagram.MouseButton;
import net.edgemind.ibee.ui.diagram.renderer.IDiagramRenderer;
import net.edgemind.ibee.ui.menu.IMenu;
import net.edgemind.ibee.ui.menu.IMenuProvider;
import net.edgemind.ibee.ui.menu.IMenuRenderer;
import net.edgemind.ibee.ui.menu.MenuFactory;
import net.edgemind.ibee.ui.toolbar.Direction;
import net.edgemind.ibee.ui.toolbar.ToolbarPanel;
import net.edgemind.ibee.util.math.Frame;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Slider;

public class SWTDiagramPanel
extends DiagramPanel {
    private Canvas canvas;
    private SWTDiagramRenderer renderer;
    private Menu contextMenu;
    private Slider hBar;
    private Slider vBar;
    private Composite parent;
    private Composite main;
    private boolean mouseDown = false;
    private Composite toolbarComposite;
    private Map<SWTKeyCode, Integer> additionalKey = new HashMap<SWTKeyCode, Integer>();
    private Map<SWTKeyCode, Integer> keyCodeCache = new HashMap<SWTKeyCode, Integer>();

    public SWTDiagramPanel(Composite parent) {
        this.parent = parent;
    }

    public void setAdditionalKey(Map<SWTKeyCode, Integer> additionalKey) {
        this.additionalKey = additionalKey;
    }

    public Composite getMainComposite() {
        return this.main;
    }

    protected void createContents() {
        GridData data;
        this.main = new Composite(this.parent, 0);
        int nrColumns = 1;
        if (this.getVerticalScrollbarEnabled()) {
            nrColumns = 2;
        }
        GridLayout layout = SwtUtil.createLayout(nrColumns, 0);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.main.setLayout((Layout)layout);
        this.main.setLayoutData((Object)new GridData(1808));
        if (this.getToolbarEnabled()) {
            this.toolbarComposite = new Composite(this.main, 0);
            this.toolbarComposite.setLayout((Layout)new GridLayout(2, false));
            data = new GridData(768);
            data.horizontalSpan = nrColumns;
            this.toolbarComposite.setLayoutData((Object)data);
        }
        this.canvas = new Canvas(this.main, 0x20000000);
        data = new GridData(1808);
        this.canvas.setLayoutData((Object)data);
        if (this.getVerticalScrollbarEnabled()) {
            this.createVerticalScrollBar(this.main);
        }
        if (this.getHorizontalScrollbarEnabled()) {
            this.createHorizontalScrollBar(this.main);
        }
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ((SWTDiagramRenderer)SWTDiagramPanel.this.getDiagramRenderer()).repaint(e.gc);
            }
        });
        this.canvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                boolean doubleClick;
                boolean bl = doubleClick = e.count > 1;
                if (doubleClick) {
                    return;
                }
                SWTDiagramPanel.this.mouseDown = false;
                SWTDiagramPanel.this.mouseUp(e.x, e.y, SWTDiagramPanel.this.getMouseButton(e));
            }

            public void mouseDown(MouseEvent e) {
                boolean doubleClick;
                boolean bl = doubleClick = e.count > 1;
                if (doubleClick) {
                    return;
                }
                if (SWTDiagramPanel.this.getMouseButton(e) == MouseButton.LEFT) {
                    SWTDiagramPanel.this.mouseDown = true;
                }
                SWTDiagramPanel.this.mouseDown(e.x, e.y, SWTDiagramPanel.this.getMouseButton(e));
            }

            public void mouseDoubleClick(MouseEvent e) {
                SWTDiagramPanel.this.doubleClick(e.x, e.y, SWTDiagramPanel.this.getMouseButton(e));
            }
        });
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                SWTDiagramPanel.this.mouseMove(e.x, e.y);
            }
        });
        this.canvas.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                SWTDiagramPanel.this.keyPressedAction(e.stateMask, -1);
                SWTDiagramPanel.this.mouseScroll(-e.count);
                SWTDiagramPanel.this.keyReleasedAction(e.stateMask, -1);
            }
        });
        this.canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                SWTDiagramPanel.this.keyReleasedAction(e.stateMask, e.keyCode);
            }

            public void keyPressed(KeyEvent e) {
                SWTDiagramPanel.this.keyPressedAction(e.stateMask, e.keyCode);
            }
        });
        this.canvas.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                SWTDiagramPanel.this.resized(SWTDiagramPanel.this.getClientWidth(), SWTDiagramPanel.this.getClientHeight());
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.contextMenu = new Menu((Decorations)this.getCanvas().getShell(), 8);
        this.getCanvas().setMenu(this.contextMenu);
        this.contextMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                if (SWTDiagramPanel.this.mouseDown) {
                    SWTDiagramPanel.this.mouseDown = false;
                    SWTDiagramPanel.this.mouseUp(0.0, 0.0, MouseButton.RIGHT);
                }
                if (SWTDiagramPanel.this.menuProviders != null) {
                    IMenu menu = MenuFactory.createMenu();
                    for (IMenuProvider provider : SWTDiagramPanel.this.menuProviders) {
                        List items = provider.create();
                        if (items == null) continue;
                        menu.addItems(items);
                    }
                    SWTDiagramPanel.this.getMenuRenderer().setAutoClear(true);
                    SWTDiagramPanel.this.getMenuRenderer().renderMenu(menu, 0.0, 0.0);
                }
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTDiagramPanel.this.disposeCursor();
            }
        });
        ((SWTDiagramRenderer)this.getDiagramRenderer()).init(this.canvas);
    }

    private void keyPressedAction(Integer stateMask, Integer keyCode) {
        Integer resultKeyCode = null;
        SWTKeyCode swtKeyCode = new SWTKeyCode(stateMask, keyCode);
        if (this.keyCodeCache.containsKey(swtKeyCode)) {
            resultKeyCode = this.keyCodeCache.get(swtKeyCode);
        }
        for (SWTKeyCode swtKeySet : this.additionalKey.keySet()) {
            if (swtKeySet.activationTime != SWTKeyCode.KeyCodeActivationTime.Pressed || (stateMask & swtKeySet.stateMask) != swtKeySet.stateMask || keyCode != swtKeySet.keyCode) continue;
            resultKeyCode = this.additionalKey.get(swtKeySet);
        }
        if (resultKeyCode == null) {
            resultKeyCode = this.getDefaultKeyCodePressed(stateMask, keyCode);
        }
        this.keyPress(resultKeyCode);
        this.keyCodeCache.put(swtKeyCode, resultKeyCode);
    }

    private void keyReleasedAction(Integer stateMask, Integer keyCode) {
        Integer resultKeyCode = null;
        SWTKeyCode swtKeyCode = new SWTKeyCode(stateMask, keyCode);
        if (this.keyCodeCache.containsKey(swtKeyCode)) {
            resultKeyCode = this.keyCodeCache.get(swtKeyCode);
        }
        for (SWTKeyCode swtKeySet : this.additionalKey.keySet()) {
            if (swtKeySet.activationTime != SWTKeyCode.KeyCodeActivationTime.Release || (stateMask & swtKeySet.stateMask) != swtKeySet.stateMask || keyCode != swtKeySet.keyCode) continue;
            resultKeyCode = this.additionalKey.get(swtKeySet);
        }
        if (resultKeyCode == null) {
            resultKeyCode = this.getDefaultKeyCodeReleased(stateMask, keyCode);
        }
        this.keyRelease(resultKeyCode);
        this.keyCodeCache.put(swtKeyCode, resultKeyCode);
    }

    public int getDefaultKeyCodeReleased(int stateMask, int keyCode) {
        int keycode = keyCode;
        if (keyCode == 127) {
            keycode = KeyCodes.DEL;
        } else if ((stateMask & 0x40000) == 262144 && keyCode == 122) {
            keycode = KeyCodes.UNDO;
        } else if ((stateMask & 0x40000) == 262144 && keyCode == 121) {
            keycode = KeyCodes.REDO;
        } else if ((stateMask & 0x40000) == 262144 && keyCode == -1) {
            keycode = KeyCodes.CTRL;
        }
        return keycode;
    }

    public int getDefaultKeyCodePressed(int stateMask, int keyCode) {
        int keycode = keyCode;
        keycode = (stateMask & 0x40000) == 262144 && keyCode == 99 ? KeyCodes.COPY : ((stateMask & 0x40000) == 262144 && keyCode == 118 ? KeyCodes.PASTE : ((stateMask & 0x40000) == 262144 && keyCode == 120 ? KeyCodes.CUT : ((stateMask & 0x40000) == 262144 && keyCode == 97 ? KeyCodes.MARK_ALL : ((stateMask & 0x40000) == 262144 && keyCode == 116 ? KeyCodes.TAG : ((stateMask & 0x40000) == 262144 && keyCode == 122 ? KeyCodes.UNDO : ((stateMask & 0x40000) == 262144 && keyCode == 121 ? KeyCodes.REDO : ((stateMask & 0x40000) == 262144 && keyCode == 115 ? KeyCodes.SAVE : ((stateMask & 0x40000) == 262144 && keyCode == 100 ? KeyCodes.DUPLICATE : ((stateMask & 0x40000) == 262144 && keyCode == 102 ? KeyCodes.FIND : ((stateMask & 0x40000) == 262144 && keyCode == -1 ? KeyCodes.CTRL : (keyCode == 262144 ? KeyCodes.CTRL : ((stateMask & 0x20000) == 131072 && keyCode == 0x1000001 ? KeyCodes.ALIGN_UP : ((stateMask & 0x20000) == 131072 && keyCode == 0x1000002 ? KeyCodes.ALIGN_DOWN : ((stateMask & 0x20000) == 131072 && keyCode == 0x1000003 ? KeyCodes.ALIGN_LEFT : ((stateMask & 0x20000) == 131072 && keyCode == 0x1000004 ? KeyCodes.ALIGN_RIGHT : (keyCode == 131072 ? KeyCodes.SHIFT : (keyCode == 127 ? KeyCodes.DEL : (keyCode == 32 ? KeyCodes.SPACE : (keyCode == 0x1000001 ? KeyCodes.UP : (keyCode == 0x1000002 ? KeyCodes.DOWN : (keyCode == 0x1000003 ? KeyCodes.LEFT : (keyCode == 0x1000004 ? KeyCodes.RIGHT : (keyCode == 27 ? KeyCodes.ESC : -1)))))))))))))))))))))));
        return keycode;
    }

    public double getClientWidth() {
        return this.canvas.getClientArea().width;
    }

    public double getClientHeight() {
        return this.canvas.getClientArea().height;
    }

    public void showCursor(CURSOR cursor) {
        this.disposeCursor();
        Cursor swtCursor = cursor == CURSOR.HAND ? new Cursor((Device)this.canvas.getDisplay(), 21) : (cursor == CURSOR.CROSS ? new Cursor((Device)this.canvas.getDisplay(), 2) : (cursor == CURSOR.ERROR ? new Cursor((Device)this.canvas.getDisplay(), 20) : (cursor == CURSOR.RESIZE_V ? SwtCursor.getCursorResizeUpDown() : (cursor == CURSOR.RESIZE_H ? SwtCursor.getCursorResizeLeftRight() : (cursor == CURSOR.RESIZE_D_L ? SwtCursor.getCursorResizeDiagonal() : (cursor == CURSOR.RESIZE_D_R ? SwtCursor.getCursorResizeDiagonal2() : new Cursor((Device)this.canvas.getDisplay(), 0)))))));
        this.canvas.setCursor(swtCursor);
    }

    private void disposeCursor() {
        if (this.canvas.getCursor() != null) {
            this.canvas.getCursor().dispose();
        }
    }

    public IDiagramRenderer getDiagramRenderer() {
        if (this.renderer == null) {
            this.renderer = new SWTDiagramRenderer();
        }
        return this.renderer;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    private MouseButton getMouseButton(MouseEvent event) {
        if (event.button == 1) {
            return MouseButton.LEFT;
        }
        if (event.button == 2) {
            return MouseButton.MIDDLE;
        }
        if (event.button == 3) {
            return MouseButton.RIGHT;
        }
        return MouseButton.NONE;
    }

    public IMenuRenderer getMenuRenderer() {
        return new SWTMenuRenderer(this.contextMenu);
    }

    public void setVerticalScroll(double scrollCurrent, double scrollMax) {
        try {
            this.vBar.setRedraw(false);
            int clientHeight = this.getCanvas().getClientArea().height;
            this.vBar.setMaximum((int)(scrollMax + (double)clientHeight));
            this.vBar.setThumb(clientHeight);
            this.vBar.setSelection((int)scrollCurrent);
        }
        finally {
            this.vBar.setRedraw(true);
            this.vBar.update();
        }
    }

    public void setHorizontalScroll(double scrollCurrent, double scrollMax) {
        int clientWidth = this.getCanvas().getClientArea().width;
        try {
            this.hBar.setRedraw(false);
            this.hBar.setMaximum((int)(scrollMax + (double)clientWidth));
            this.hBar.setThumb(clientWidth);
            this.hBar.setSelection((int)scrollCurrent);
        }
        finally {
            this.hBar.setRedraw(true);
            this.hBar.update();
        }
    }

    private void createVerticalScrollBar(Composite parent) {
        this.vBar = new Slider(parent, 512);
        GridData data = new GridData(1040);
        this.vBar.setLayoutData((Object)data);
        int THUMB_SIZE = 5;
        this.vBar.setMaximum(100 + THUMB_SIZE);
        this.vBar.setPageIncrement(5);
        this.vBar.setIncrement(5);
        this.vBar.setThumb(THUMB_SIZE);
        this.vBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SWTDiagramPanel.this.diagram != null) {
                    Frame frame = SWTDiagramPanel.this.diagram.getSize(false);
                    SWTDiagramPanel.this.setTranslateY((double)SWTDiagramPanel.this.vBar.getSelection() / SWTDiagramPanel.this.getZoomY() + frame.getY());
                    SWTDiagramPanel.this.refreshPage();
                }
            }
        });
    }

    private void createHorizontalScrollBar(Composite parent) {
        this.hBar = new Slider(parent, 256);
        GridData data = new GridData(768);
        this.hBar.setLayoutData((Object)data);
        int THUMB_SIZE = 5;
        this.hBar.setMaximum(100 + THUMB_SIZE);
        this.hBar.setPageIncrement(5);
        this.hBar.setIncrement(5);
        this.hBar.setThumb(THUMB_SIZE);
        this.hBar.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SWTDiagramPanel.this.diagram != null) {
                    Frame frame = SWTDiagramPanel.this.diagram.getSize(false);
                    SWTDiagramPanel.this.setTranslateX((double)SWTDiagramPanel.this.hBar.getSelection() / SWTDiagramPanel.this.getZoomX() + frame.getX());
                    SWTDiagramPanel.this.refreshPage();
                }
            }
        });
    }

    public ToolbarPanel createToolbarPanel1() {
        Composite toolbar1Composite = new Composite(this.toolbarComposite, 0);
        toolbar1Composite.setLayout((Layout)new GridLayout());
        toolbar1Composite.setLayoutData((Object)new GridData(768));
        return new SwtToolbarPanel(toolbar1Composite, Direction.HORIZONTAL);
    }

    public ToolbarPanel createToolbarPanel2() {
        Composite toolbar2Composite = new Composite(this.toolbarComposite, 0);
        toolbar2Composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(768);
        data.horizontalAlignment = 131072;
        toolbar2Composite.setLayoutData((Object)data);
        return new SwtToolbarPanel(toolbar2Composite, Direction.HORIZONTAL);
    }

    public Object getUIComponent() {
        return this.canvas;
    }

    public Point getDisplayDPI() {
        if (this.canvas == null) {
            return new Point(100.0, 100.0);
        }
        return new Point((double)this.canvas.getDisplay().getDPI().x, (double)this.canvas.getDisplay().getDPI().y);
    }
}

