/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.swt.core.image.ImageUtil;
import net.edgemind.ibee.swt.core.util.SwtUtil;
import net.edgemind.ibee.ui.column.Column;
import net.edgemind.ibee.ui.column.IColorProvider;
import net.edgemind.ibee.ui.column.IIconProvider;
import net.edgemind.ibee.ui.table.ITooltipSupport;
import net.edgemind.ibee.util.Tuple;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class SwtColumnLabelProvider<T>
extends ColumnLabelProvider {
    private Column<T> column;
    private IColorProvider<T> colorProvider;
    private IIconProvider<T> iconProvider;
    private ITooltipSupport<T> tooltipSupport;
    private static final Color DEFAULT_BACKGROUND_COLOR = Color.WHITE;
    private static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;

    public SwtColumnLabelProvider(Column<T> column) {
        this.column = column;
        this.colorProvider = column.getColorProvider();
        this.iconProvider = column.getIconProvider();
        this.tooltipSupport = column.getTooltipSupport();
    }

    public String getText(Object element) {
        return this.column.getValue(element);
    }

    public String getToolTipText(Object element) {
        if (this.tooltipSupport != null) {
            return this.tooltipSupport.getTooltip(element);
        }
        return this.column.getValue(element);
    }

    public org.eclipse.swt.graphics.Color getBackground(Object element) {
        if (this.colorProvider != null) {
            return SwtUtil.toSwtColor(this.colorProvider.getBackground(element));
        }
        return SwtUtil.toSwtColor(DEFAULT_BACKGROUND_COLOR);
    }

    public org.eclipse.swt.graphics.Color getForeground(Object element) {
        if (this.colorProvider != null) {
            return SwtUtil.toSwtColor(this.colorProvider.getForeground(element));
        }
        return SwtUtil.toSwtColor(DEFAULT_FOREGROUND_COLOR);
    }

    public Image getImage(Object element) {
        if (this.iconProvider != null) {
            Tuple imageInfo = this.iconProvider.getImage(element);
            return ImageUtil.getImage((String)imageInfo.first, (Class)imageInfo.second);
        }
        return null;
    }
}

