/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.nebula.jface.gridviewer.GridColumnLayout;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;

public class SwtGridColumnLayout
extends GridColumnLayout {
    private boolean relayout = true;

    protected void layout(Composite composite, boolean flushCache) {
        int tableWidth;
        Rectangle area = composite.getClientArea();
        Scrollable table = (Scrollable)composite.getChildren()[0];
        int trim = this.computeTrim(table, tableWidth = table.getSize().x);
        int width = Math.max(0, area.width - trim);
        if (width > 1) {
            this.layoutTableTree(table, width, area, tableWidth < area.width);
        }
        if (this.relayout) {
            this.relayout = false;
            composite.layout();
        }
    }

    private int computeTrim(Scrollable scrollable, int currentWidth) {
        int trim = currentWidth > 1 ? currentWidth - scrollable.getClientArea().width : 2 * scrollable.getBorderWidth() + 1;
        return trim;
    }

    private void layoutTableTree(Scrollable scrollable, int width, Rectangle area, boolean increase) {
        boolean recalculate;
        int numberOfColumns = this.getColumnCount(scrollable);
        int[] widths = new int[numberOfColumns];
        int[] weightColumnIndices = new int[numberOfColumns];
        int numberOfWeightColumns = 0;
        int fixedWidth = 0;
        int totalWeight = 0;
        ((Grid)scrollable).getColumns();
        int i = 0;
        while (i < numberOfColumns) {
            ColumnLayoutData col = this.getLayoutData(scrollable, i);
            if (col instanceof ColumnPixelData) {
                ColumnPixelData cpd = (ColumnPixelData)col;
                int pixels = cpd.width;
                if (cpd.addTrim) {
                    pixels += this.getColumnTrim();
                }
                widths[i] = pixels;
                fixedWidth += pixels;
            } else if (col instanceof ColumnWeightData) {
                ColumnWeightData cw = (ColumnWeightData)col;
                weightColumnIndices[numberOfWeightColumns] = i;
                ++numberOfWeightColumns;
                totalWeight += cw.weight;
                widths[i] = cw.minimumWidth;
            } else {
                Assert.isTrue((boolean)false, (String)"Unknown column layout data");
            }
            ++i;
        }
        block1: do {
            recalculate = false;
            int i2 = 0;
            while (i2 < numberOfWeightColumns) {
                int allowedWidth;
                int colIndex = weightColumnIndices[i2];
                ColumnWeightData cw = (ColumnWeightData)this.getLayoutData(scrollable, colIndex);
                int minWidth = cw.minimumWidth;
                int n = allowedWidth = totalWeight == 0 ? 0 : (width - fixedWidth) * cw.weight / totalWeight;
                if (allowedWidth < minWidth) {
                    --numberOfWeightColumns;
                    totalWeight -= cw.weight;
                    fixedWidth += minWidth;
                    if (widths[colIndex] > minWidth) continue block1;
                    widths[colIndex] = minWidth;
                    System.arraycopy(weightColumnIndices, i2 + 1, weightColumnIndices, i2, numberOfWeightColumns - i2);
                    recalculate = true;
                    continue block1;
                }
                if (widths[colIndex] > allowedWidth) continue block1;
                widths[colIndex] = allowedWidth;
                ++i2;
            }
        } while (recalculate);
        if (increase) {
            scrollable.setBounds(0, 0, area.width, area.height);
        }
        this.setColumnWidths(scrollable, widths);
        scrollable.update();
        if (!increase) {
            scrollable.setBounds(0, 0, area.width, area.height);
        }
    }
}

