/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import net.edgemind.ibee.core.app.IEvent;
import net.edgemind.ibee.swt.core.renderer.SwtColumnLabelProvider;
import net.edgemind.ibee.swt.core.renderer.SwtGridColumnLayout;
import net.edgemind.ibee.ui.column.Column;
import net.edgemind.ibee.ui.common.event.MouseDblClickEvent;
import net.edgemind.ibee.ui.table.Table;
import net.edgemind.ibee.ui.z.renderer.AZRenderer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.jface.gridviewer.GridColumnLayout;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SwtTableRenderer2<T>
extends AZRenderer<Table<T>> {
    private int sortCol = -1;
    private int sortDirection = 0;
    private final int DEFAULT_MINIMUM_COLUMN_WIDTH = 100;
    private Composite parent;
    private GridTableViewer tableViewer;
    private GridColumnLayout tableColumnLayout;
    private boolean renderingQueued = false;

    public SwtTableRenderer2(Composite parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRender(Table<T> table) {
        if (this.tableViewer == null) {
            this.createViewer(table);
        }
        SwtTableRenderer2 swtTableRenderer2 = this;
        synchronized (swtTableRenderer2) {
            if (this.renderingQueued) {
                return;
            }
            this.renderingQueued = true;
        }
        this.parent.getDisplay().asyncExec(() -> {
            SwtTableRenderer2 swtTableRenderer2 = this;
            synchronized (swtTableRenderer2) {
                this.renderingQueued = false;
            }
            this.tableViewer.setInput((Object)table.getTableData());
        });
    }

    private void createViewer(Table<T> table) {
        Composite tableComposite = new Composite(this.parent, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        this.tableColumnLayout = new SwtGridColumnLayout();
        tableComposite.setLayout((Layout)this.tableColumnLayout);
        this.tableViewer = new GridTableViewer(tableComposite, 768);
        Grid tableWidget = this.getTableWidget();
        table.setUIObject((Object)tableWidget);
        tableWidget.setHeaderVisible(true);
        tableWidget.setLinesVisible(true);
        tableWidget.setCellSelectionEnabled(table.isCellSelectionEnabled());
        this.tableViewer.setUseHashlookup(true);
        this.createSelectionListener(table);
        this.createDblClickListener(table);
        this.createColumns(table);
        this.createContent(table);
        if (table.getFilter() != null) {
            this.createFilter(table);
        }
        if (table.isSortEnabled()) {
            this.createComparator(table);
        }
        if (table.isTooltipEnabled()) {
            this.createTooltipSupport(table);
        }
    }

    private void createColumns(Table<T> table) {
        List columns = table.getTableColumns();
        ListIterator iterator = columns.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            Column col = (Column)iterator.next();
            GridViewerColumn column = new GridViewerColumn(this.tableViewer, 0);
            column.getColumn().setText(col.getTitle());
            column.setLabelProvider(new SwtColumnLabelProvider(col));
            column.getColumn().getCellRenderer().setWordWrap(true);
            int colWidth = col.getMinimumWidth();
            if (colWidth == 0) {
                colWidth = 100;
            }
            column.getColumn().setWidth(colWidth);
            column.getColumn().setMinimumWidth(colWidth);
            this.tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, colWidth));
            if (!table.isSortEnabled()) continue;
            column.getColumn().addListener(13, e -> this.changeSort(index));
        }
    }

    private void createTooltipSupport(Table<T> table) {
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
    }

    private void createComparator(final Table<T> table) {
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int v = 0;
                if (SwtTableRenderer2.this.sortDirection == 0 || SwtTableRenderer2.this.sortCol < 0) {
                    return 0;
                }
                if (SwtTableRenderer2.this.sortCol >= 0) {
                    Column col = (Column)table.getTableColumns().get(SwtTableRenderer2.this.sortCol);
                    if (col.getSorter() != null) {
                        v = col.getSorter().compareEquals(e1, e2);
                    } else {
                        String name1 = this.getLabel(e1, col);
                        String name2 = this.getLabel(e2, col);
                        v = name1.compareToIgnoreCase(name2);
                    }
                } else {
                    v = super.compare(viewer, e1, e2);
                }
                if (SwtTableRenderer2.this.sortDirection == 128) {
                    v = -v;
                }
                return v;
            }

            private String getLabel(Object e1, Column col) {
                return col.getValueProvider().getValue(e1);
            }
        });
    }

    private void createFilter(final Table<T> table) {
        this.tableViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return table.getFilter().accept(element);
            }
        }});
    }

    private void createContent(Table<T> table) {
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
    }

    public void changeSort(int col) {
        if (this.sortCol == col) {
            this.sortDirection = this.sortDirection == 0 ? 1024 : (this.sortDirection == 1024 ? 128 : 0);
            this.tableViewer.getGrid().getColumn(col).setSort(this.sortDirection);
        } else {
            if (this.sortCol >= 0) {
                this.tableViewer.getGrid().getColumn(this.sortCol).setSort(0);
            }
            this.sortDirection = 1024;
            this.sortCol = col;
            this.tableViewer.getGrid().getColumn(col).setSort(this.sortDirection);
        }
        this.tableViewer.refresh();
    }

    protected void createSelectionListener(Table<T> table) {
        this.tableViewer.getControl().addListener(13, e -> {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
            if (selection == null) {
                return;
            }
            table.changeSelection((Collection)selection.toList());
        });
    }

    protected void createDblClickListener(Table<T> table) {
        this.tableViewer.getControl().addListener(8, e -> {
            IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
            if (selection == null) {
                return;
            }
            if (selection.size() == 1) {
                MouseDblClickEvent event = new MouseDblClickEvent(selection.getFirstElement());
                table.fireEvent((IEvent)event);
            }
        });
    }

    public Grid getTableWidget() {
        return this.tableViewer.getGrid();
    }

    public Control getTableControl() {
        return this.tableViewer.getControl();
    }
}

