/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.renderer;

import java.util.List;
import java.util.ListIterator;
import net.edgemind.ibee.swt.core.renderer.SwtColumnLabelProvider;
import net.edgemind.ibee.swt.core.renderer.SwtGridColumnLayout;
import net.edgemind.ibee.ui.column.Column;
import net.edgemind.ibee.ui.tree.Tree;
import net.edgemind.ibee.ui.z.renderer.AZRenderer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.nebula.jface.gridviewer.GridColumnLayout;
import org.eclipse.nebula.jface.gridviewer.GridTreeViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerColumn;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SwtTreeRenderer2<T>
extends AZRenderer<Tree<T>> {
    private final int DEFAULT_MINIMUM_COLUMN_WIDTH = 100;
    private Composite parent;
    private Tree<T> tree;
    private GridTreeViewer treeViewer;
    private GridColumnLayout tableColumnLayout;
    private boolean renderingQueued = false;
    private int maxChildren = -1;

    public SwtTreeRenderer2(Composite parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRender(Tree<T> tree) {
        this.tree = tree;
        if (this.treeViewer == null) {
            this.createTreeWidget();
        }
        SwtTreeRenderer2 swtTreeRenderer2 = this;
        synchronized (swtTreeRenderer2) {
            if (this.renderingQueued) {
                return;
            }
            this.renderingQueued = true;
        }
        this.parent.getDisplay().asyncExec(() -> {
            SwtTreeRenderer2 swtTreeRenderer2 = this;
            synchronized (swtTreeRenderer2) {
                this.renderingQueued = false;
            }
            this.treeViewer.setInput((Object)"ROOT");
        });
    }

    public Grid getGridWidget() {
        return this.treeViewer.getGrid();
    }

    public Control getControl() {
        return this.treeViewer.getGrid();
    }

    private void createTreeWidget() {
        Composite tableComposite = new Composite(this.parent, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        this.tableColumnLayout = new SwtGridColumnLayout();
        tableComposite.setLayout((Layout)this.tableColumnLayout);
        this.treeViewer = new GridTreeViewer(tableComposite, 768);
        Grid treeWidget = this.getGridWidget();
        this.tree.setUIObject((Object)treeWidget);
        treeWidget.setHeaderVisible(true);
        treeWidget.setLinesVisible(true);
        this.createColumns();
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                return !SwtTreeRenderer2.this.tree.getItemProvider().getChilds(element).isEmpty();
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{SwtTreeRenderer2.this.tree.getItemProvider().getRootItem()};
            }

            public Object[] getChildren(Object parentElement) {
                List childs = SwtTreeRenderer2.this.tree.getItemProvider().getChilds(parentElement);
                if (childs != null) {
                    if (SwtTreeRenderer2.this.maxChildren > 0 && childs.size() > SwtTreeRenderer2.this.maxChildren) {
                        childs = childs.subList(0, SwtTreeRenderer2.this.maxChildren);
                    }
                    return childs.toArray();
                }
                return new Object[0];
            }
        });
        this.treeViewer.addSelectionChangedListener(event -> this.tree.changeSelection(event.getStructuredSelection().getFirstElement()));
    }

    private void createColumns() {
        List columns = this.tree.getColumns();
        ListIterator iterator = columns.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            Column col = (Column)iterator.next();
            GridViewerColumn column = new GridViewerColumn(this.treeViewer, 0);
            column.getColumn().setText(col.getTitle());
            if (index == 0) {
                column.getColumn().setTree(true);
            }
            column.setLabelProvider(new SwtColumnLabelProvider(col));
            column.getColumn().getCellRenderer().setWordWrap(true);
            int colWidth = col.getMinimumWidth();
            if (colWidth == 0) {
                colWidth = 100;
            }
            column.getColumn().setWidth(colWidth);
            column.getColumn().setMinimumWidth(colWidth);
            this.tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, colWidth));
        }
    }
}

