/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.util;

import net.edgemind.ibee.swt.core.util.ToolTip;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class CellHoverCreator {
    public void connectHovering(Table table) {
        ToolTip tooltip = new ToolTip(table.getDisplay());
        Color color = new Color((Device)table.getDisplay(), 255, 255, 0);
        tooltip.setBackgroundColor(color);
        table.addListener(32, event -> {
            Point point = new Point(event.x, event.y);
            TableItem item = table.getItem(point);
            if (item != null) {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < table.getColumnCount()) {
                    TableColumn col = table.getColumn(i);
                    buf.append(col.getText() + ": " + item.getText(i) + "\n");
                    ++i;
                }
                String cellText = buf.toString().trim();
                Point location = table.toDisplay(event.x, event.y);
                if (!table.isDisposed()) {
                    tooltip.show(cellText, location, true);
                }
            } else {
                tooltip.hide();
            }
        });
        table.addListener(12, event -> color.dispose());
        table.addListener(5, event -> tooltip.hide());
    }

    public void connectHovering(Tree tree) {
        ToolTip tooltip = new ToolTip(tree.getDisplay());
        Color color = new Color((Device)tree.getDisplay(), 255, 255, 0);
        tooltip.setBackgroundColor(color);
        tree.addListener(32, event -> {
            Point point = new Point(event.x, event.y);
            TreeItem item = tree.getItem(point);
            if (item != null) {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < tree.getColumnCount()) {
                    TreeColumn col = tree.getColumn(i);
                    buf.append(col.getText() + ": " + item.getText(i) + "\n");
                    ++i;
                }
                String cellText = buf.toString().trim();
                Point location = tree.toDisplay(event.x, event.y);
                if (!tree.isDisposed()) {
                    tooltip.show(cellText, location, true);
                }
            } else {
                tooltip.hide();
            }
        });
        tree.addListener(12, event -> color.dispose());
        tree.addListener(5, event -> tooltip.hide());
    }
}

