/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.edgemind.ibee.core.diagram.Color;
import net.edgemind.ibee.core.exception.IbeeException;
import net.edgemind.ibee.core.exception.ManualInteruptionException;
import net.edgemind.ibee.swt.core.dialog.ICallable;
import net.edgemind.ibee.swt.core.dialog.ICallableWithProgress;
import net.edgemind.ibee.swt.core.dialog.ICallableWithoutError;
import net.edgemind.ibee.swt.core.dialog.IRunnable;
import net.edgemind.ibee.swt.core.dialog.IRunnableWithoutError;
import net.edgemind.ibee.swt.core.dialog.SwtConfirmationDlg;
import net.edgemind.ibee.swt.core.field.FieldData;
import net.edgemind.ibee.swt.core.util.AsyncObject;
import net.edgemind.ibee.swt.core.util.SyncObject;
import net.edgemind.ibee.util.file.FileUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SwtUtil {
    private static Map<String, org.eclipse.swt.graphics.Color> sSwtColors = new HashMap<String, org.eclipse.swt.graphics.Color>();

    public static void addFieldColoring(FieldData<?> field, org.eclipse.swt.graphics.Color colorValid, org.eclipse.swt.graphics.Color colorInvalid) {
        FieldData.IModifiedListener<Object> listener = value -> {
            if (field.getControl() == null) {
                return;
            }
            if (field.getErrorMsg() != null) {
                field.getControl().setBackground(colorInvalid);
            } else {
                field.getControl().setBackground(colorValid);
            }
        };
        field.addModifiedListener(listener);
        listener.modified(field.getValue());
    }

    public static Point computesize(Control c) {
        Point size = c.computeSize(-1, -1, true);
        if (c instanceof Composite) {
            Composite comp = (Composite)c;
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cChild = controlArray[n2];
                Point cSize = SwtUtil.computesize(cChild);
                if (cSize.x > size.x) {
                    size.x = cSize.x;
                }
                if (cSize.y > size.y) {
                    size.y = cSize.y;
                }
                ++n2;
            }
        }
        return size;
    }

    public static int confirmWithCancel(final String title, final String question, final Shell shell) {
        return SwtUtil.runInGui(new ICallableWithoutError<Integer>(){

            @Override
            public Integer call() {
                MessageBox messageBox = new MessageBox(shell, 452);
                messageBox.setMessage(question);
                messageBox.setText(title);
                int response = messageBox.open();
                return response;
            }
        }, shell);
    }

    public static GridLayout createLayout(int cols, boolean equal) {
        return SwtUtil.createLayout(cols, equal, 1);
    }

    public static GridLayout createLayout(int cols, int margin) {
        return SwtUtil.createLayout(cols, false, margin);
    }

    public static GridLayout createLayout(int cols, boolean equal, int margin) {
        GridLayout layout = new GridLayout(cols, equal);
        layout.marginBottom = margin;
        layout.marginTop = margin;
        layout.marginLeft = margin;
        layout.marginRight = margin;
        layout.marginWidth = margin;
        layout.marginHeight = margin;
        return layout;
    }

    public static GridData createLayoutData(int width) {
        GridData data = new GridData(1);
        data.widthHint = width;
        data.grabExcessHorizontalSpace = false;
        return data;
    }

    public static Pattern createPatternAndHighlightText(String patternS, Text text) {
        Pattern pattern = null;
        if (patternS.startsWith("/")) {
            try {
                pattern = Pattern.compile(patternS.substring(1), 2);
                text.setForeground(Display.getCurrent().getSystemColor(9));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                pattern = null;
                text.setForeground(Display.getCurrent().getSystemColor(3));
            }
        } else if (patternS.trim().equals("")) {
            pattern = Pattern.compile("");
        } else {
            patternS = patternS.replaceAll("\\*", "[\\\\w]*");
            pattern = Pattern.compile("^" + patternS, 2);
            text.setForeground(Display.getCurrent().getSystemColor(2));
            pattern = null;
        }
        return pattern;
    }

    public static void disposeSwtTranslations() {
        for (String color : sSwtColors.keySet()) {
            sSwtColors.get(color).dispose();
        }
        sSwtColors.clear();
    }

    public static void enableWidget(Control control, boolean value, boolean recursive) {
        control.setEnabled(value);
        if (recursive && control instanceof Composite) {
            Control[] childControls;
            Composite composite = (Composite)control;
            Control[] controlArray = childControls = composite.getChildren();
            int n = childControls.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                SwtUtil.enableWidget(childControl, value, recursive);
                ++n2;
            }
        }
    }

    public static void fillHorizontal(Control c) {
        GridData data = new GridData(768);
        c.setLayoutData((Object)data);
    }

    public static void hide(final Control c) {
        SwtUtil.runInGui(new IRunnableWithoutError(){

            @Override
            public void run() {
                c.setVisible(false);
            }
        }, c.getShell());
    }

    private static String[] normalizeFileExtensions(String[] ext) {
        if (ext != null) {
            String[] ext2 = new String[ext.length];
            int index = 0;
            String[] stringArray = ext;
            int n = ext.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                Object extension = "";
                boolean firstRun = true;
                String[] stringArray2 = e.split(";");
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object subExtension = stringArray2[n4];
                    if (subExtension != null && !((String)subExtension).startsWith("*.")) {
                        subExtension = "*." + (String)subExtension;
                    }
                    if (firstRun) {
                        extension = subExtension;
                        firstRun = false;
                    } else {
                        extension = (String)extension + ";" + (String)subExtension;
                    }
                    ++n4;
                }
                ext2[index] = extension;
                ++index;
                ++n2;
            }
            ext = ext2;
        }
        return ext;
    }

    public static boolean openConfirmDlg(final Shell shell, final String title, final String msg) {
        return SwtUtil.runInGui(new ICallableWithoutError<Boolean>(){

            @Override
            public Boolean call() {
                return MessageDialog.openConfirm((Shell)shell, (String)title, (String)msg);
            }
        }, shell);
    }

    public static void openErrorDlg(final Shell shell, final String title, final String msg) {
        SwtUtil.runInGui(new IRunnableWithoutError(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        }, shell);
    }

    public static void openInfoDlg(final Shell shell, final String title, final String msg) {
        SwtUtil.runInGui(new IRunnableWithoutError(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
            }
        }, shell);
    }

    public static String openInputDlg(final Shell shell, final String title, final String prompt) {
        return SwtUtil.runInGui(new ICallableWithoutError<String>(){

            @Override
            public String call() {
                InputDialog inputDialog = new InputDialog(shell, title, prompt, "", null);
                if (inputDialog.open() == 0) {
                    String input = inputDialog.getValue();
                    return input;
                }
                return null;
            }
        }, shell);
    }

    public static boolean openQuestionDlg(final Shell shell, final String title, final String msg) {
        return SwtUtil.runInGui(new ICallableWithoutError<Boolean>(){

            @Override
            public Boolean call() {
                return MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg);
            }
        }, shell);
    }

    public static void openWarningDlg(final Shell shell, final String title, final String msg) {
        SwtUtil.runInGui(new IRunnableWithoutError(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)shell, (String)title, (String)msg);
            }
        }, shell);
    }

    public static String promptDirPath(final String title, final String prePath, final Shell shell, final int style) {
        return SwtUtil.runInGui(new ICallableWithoutError<String>(){

            @Override
            public String call() {
                DirectoryDialog dirDialog = new DirectoryDialog(shell, style);
                String filePath = prePath;
                if (filePath != null && FileUtil.fileExists((String)filePath)) {
                    dirDialog.setFilterPath(filePath);
                }
                dirDialog.setText(title);
                return dirDialog.open();
            }
        }, shell);
    }

    public static String promptDirPathRead(String title, String prePath, Shell shell) {
        return SwtUtil.promptDirPath(title, prePath, shell, 4096);
    }

    public static String promptDirPathSave(String title, String prePath, Shell shell) {
        String path = SwtUtil.promptDirPath(title, prePath, shell, 8192);
        return path;
    }

    private static String promptFilePath(final String title, final String prePath, final Shell shell, final int style, final String[] ext, final String[] extLabels) {
        return SwtUtil.runInGui(new ICallableWithoutError<String>(){

            @Override
            public String call() {
                String filePath;
                FileDialog fileDialog = new FileDialog(shell, style);
                fileDialog.setText(title);
                if (ext != null && ext.length > 0) {
                    if (extLabels != null && extLabels.length == ext.length) {
                        String[] labels = new String[ext.length];
                        int i = 0;
                        while (i < ext.length) {
                            labels[i] = String.format("%s (%s)", extLabels[i], SwtUtil.removeLeadingAlias(ext[i]));
                            ++i;
                        }
                        fileDialog.setFilterNames(labels);
                    }
                    fileDialog.setFilterExtensions(ext);
                }
                if ((filePath = prePath) != null && filePath.length() > 0) {
                    File filePathFile = new File(filePath);
                    boolean isDir = filePathFile.exists() && filePathFile.isDirectory();
                    File dir = filePathFile;
                    if (!filePathFile.exists() || filePathFile.isFile()) {
                        dir = filePathFile.getParentFile();
                    }
                    if (dir != null && dir.exists() && dir.isDirectory()) {
                        fileDialog.setFilterPath(dir.getAbsolutePath());
                    }
                    if (!isDir) {
                        fileDialog.setFileName(FileUtil.extractFileName((String)prePath));
                        String fileExt = FileUtil.getExtension((String)prePath);
                        if (fileExt != null && ext != null) {
                            String currentExt = "*." + fileExt;
                            int i = 0;
                            while (i < ext.length) {
                                if (ext[i].equalsIgnoreCase(currentExt)) {
                                    fileDialog.setFilterIndex(i);
                                    break;
                                }
                                ++i;
                            }
                        }
                    }
                }
                return fileDialog.open();
            }
        }, shell);
    }

    private static String removeLeadingAlias(String s) {
        if (s != null && s.startsWith("*")) {
            s = s.substring(1);
        }
        return s;
    }

    public static String promptFilePathRead(String title, String prePath, Shell shell) {
        return SwtUtil.promptFilePath(title, prePath, shell, 4096, null, null);
    }

    public static String promptFilePathRead(String title, String prePath, Shell shell, String ext, String extLabel) {
        String[] stringArray;
        String[] stringArray2;
        if (ext != null && !((String)ext).startsWith("*.")) {
            ext = "*." + (String)ext;
        }
        if (ext != null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = ext;
        } else {
            stringArray2 = null;
        }
        if (extLabel != null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = extLabel;
        } else {
            stringArray = null;
        }
        return SwtUtil.promptFilePathRead(title, prePath, shell, stringArray2, stringArray);
    }

    public static String promptFilePathRead(String title, String prePath, Shell shell, String[] ext, String[] extLabels) {
        ext = SwtUtil.normalizeFileExtensions(ext);
        return SwtUtil.promptFilePath(title, prePath, shell, 4096, ext, extLabels);
    }

    public static String promptFilePathSave(String title, String prePath, Shell shell) {
        return SwtUtil.promptFilePathSave(title, prePath, shell, true, new String[0], new String[0]);
    }

    public static String promptFilePathSave(String title, String prePath, Shell shell, boolean confirmOverwrite, String ext, String extLabel) {
        String[] stringArray;
        String[] stringArray2;
        if (ext != null && !((String)ext).startsWith("*.")) {
            ext = "*." + (String)ext;
        }
        if (ext != null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = ext;
        } else {
            stringArray2 = null;
        }
        if (extLabel != null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = extLabel;
        } else {
            stringArray = null;
        }
        return SwtUtil.promptFilePathSave(title, prePath, shell, confirmOverwrite, stringArray2, stringArray);
    }

    public static String promptFilePathSave(String title, String prePath, Shell shell, String[] ext, String[] extLabels) {
        ext = SwtUtil.normalizeFileExtensions(ext);
        return SwtUtil.promptFilePathSave(title, prePath, shell, true, ext, extLabels);
    }

    public static String promptFilePathSave(String title, String prePath, final Shell shell, final boolean confirmOverwrite, String[] ext, String[] extLabels) {
        ext = SwtUtil.normalizeFileExtensions(ext);
        final String path = SwtUtil.promptFilePath(title, prePath, shell, 8192, ext, extLabels);
        return SwtUtil.runInGui(new ICallableWithoutError<String>(){

            @Override
            public String call() {
                if (path == null || path.equals("")) {
                    return null;
                }
                if (confirmOverwrite && new File(path).exists()) {
                    MessageBox mb = new MessageBox(shell, 200);
                    mb.setMessage(path + " exists already. Overwrite?");
                    if (mb.open() != 64) {
                        return null;
                    }
                }
                return path;
            }
        }, shell);
    }

    public static <T> T runInGui(final ICallableWithProgress<T> func, Shell shell) {
        final AsyncObject result = new AsyncObject();
        net.edgemind.ibee.swt.core.dialog.IRunnableWithProgress process = new net.edgemind.ibee.swt.core.dialog.IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) {
                try {
                    result.result = func.call(monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        SwtUtil.runInGui(process, shell);
        return result.result;
    }

    public static <T> T runInGui(final ICallableWithoutError<T> func, Shell shell) {
        if (shell.getDisplay().getThread() == Thread.currentThread()) {
            return func.call();
        }
        final AsyncObject result = new AsyncObject();
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result.result = func.call();
            }
        });
        return result.result;
    }

    public static <T> T runInGui(final ICallable<T> func, Shell shell) throws IbeeException {
        if (shell.getDisplay().getThread() == Thread.currentThread()) {
            return func.call();
        }
        final AsyncObject result = new AsyncObject();
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    result.result = func.call();
                }
                catch (Exception e1) {
                    result.exception = e1;
                    throw e1;
                }
            }
        });
        return result.result;
    }

    public static void runInGui(final IRunnable func, Shell shell) {
        if (!SwtUtil.shellValid(shell)) {
            return;
        }
        if (shell.getDisplay().getThread() == Thread.currentThread()) {
            func.run();
        } else {
            final SyncObject result = new SyncObject();
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        func.run();
                    }
                    catch (IbeeException e1) {
                        result.exception = e1;
                    }
                }
            });
            if (result.exception != null) {
                throw result.exception;
            }
        }
    }

    public static void runInGui(final net.edgemind.ibee.swt.core.dialog.IRunnableWithProgress process, Shell shell) {
        if (!SwtUtil.shellValid(shell)) {
            return;
        }
        final SyncObject result = new SyncObject();
        final IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws IbeeException {
                try {
                    try {
                        process.run(monitor);
                    }
                    catch (IbeeException e) {
                        result.exception = e;
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        final ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        if (shell.getDisplay().getThread() == Thread.currentThread()) {
            try {
                dialog.run(true, true, runnable);
                dialog.close();
            }
            catch (Exception e) {
                result.exception = new IbeeException((Throwable)e);
            }
        } else {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        dialog.run(true, true, runnable);
                        dialog.close();
                    }
                    catch (Exception e) {
                        result.exception = new IbeeException((Throwable)e);
                    }
                }
            });
        }
        if (result.exception != null) {
            throw result.exception;
        }
    }

    public static void runInGui(final IRunnableWithoutError func, Shell shell) {
        if (!SwtUtil.shellValid(shell)) {
            return;
        }
        if (shell.getDisplay().getThread() == Thread.currentThread()) {
            func.run();
        } else {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    func.run();
                }
            });
        }
    }

    public static void runInGuiNonBlocking(final IRunnable func, final Shell shell) {
        if (!SwtUtil.shellValid(shell)) {
            return;
        }
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    func.run();
                }
                catch (Exception e) {
                    SwtUtil.showError(e, shell);
                }
            }
        });
    }

    public static void runInGuiNonBlocking(final net.edgemind.ibee.swt.core.dialog.IRunnableWithProgress process, final Shell shell) {
        if (!SwtUtil.shellValid(shell)) {
            return;
        }
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    SwtUtil.runInGui(process, shell);
                }
                catch (Exception e) {
                    SwtUtil.showError(e, shell);
                }
            }
        });
    }

    public static void setEnabled(Control c, boolean value) {
        c.setEnabled(value);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SwtUtil.setEnabled(child, value);
                ++n2;
            }
        }
    }

    public static void show(final Control c) {
        SwtUtil.runInGui(new IRunnableWithoutError(){

            @Override
            public void run() {
                c.setVisible(true);
            }
        }, c.getShell());
    }

    public static void showError(Throwable e, Shell shell) {
        if (!SwtUtil.shellValid(shell)) {
            e.printStackTrace();
            return;
        }
        if (e instanceof ManualInteruptionException) {
            Throwable t;
            String msg = e.getMessage();
            if ((msg == null || msg.length() == 0) && (t = e.getCause()) != null) {
                msg = t.getMessage();
            }
            if (msg == null) {
                msg = "Action Canceled by User";
            }
            SwtUtil.showInfo("Information", msg, shell);
        } else {
            SwtUtil.showError("An error occurred", e, shell);
        }
    }

    public static void showError(String title, Throwable e, Shell shell) {
        String errorMsg = SwtUtil.getDetailedErrorMessage(e);
        if (errorMsg == null || errorMsg.length() == 0) {
            errorMsg = "Unknown Error";
        }
        SwtUtil.showError(title, errorMsg, shell);
    }

    private static String getDetailedErrorMessage(Throwable e) {
        StringBuffer buf = new StringBuffer();
        SwtUtil.getDetailedErrorMessage(e, buf, 0);
        return buf.toString();
    }

    private static void getDetailedErrorMessage(Throwable e, StringBuffer buf, int depth) {
        String msg;
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
            SwtUtil.getDetailedErrorMessage(e, buf, depth);
            return;
        }
        Throwable child = e.getCause();
        if (!(child instanceof InvocationTargetException) && (msg = e.getMessage()) != null && !msg.isEmpty()) {
            msg = msg.trim();
            Object text = e.getClass().getSimpleName() + ": " + msg;
            text = depth == 0 ? e.getMessage() : (depth == 1 ? String.format("\nDetails:\n%s: %s", e.getClass().getSimpleName(), msg) : String.format("%s: %s", e.getClass().getSimpleName(), msg));
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append((String)text);
            ++depth;
        }
        if (child != null) {
            SwtUtil.getDetailedErrorMessage(child, buf, depth);
        }
    }

    public static void showError(String msg, Shell shell) {
        SwtUtil.showError("Error", msg, shell);
    }

    public static void showError(String title, String msg, Shell shell) {
        Shell shellFinal;
        Shell shell2 = shellFinal = SwtUtil.shellValid(shell) ? shell : new Shell();
        if (shellFinal.getDisplay().getThread() != Thread.currentThread()) {
            Display.getDefault().asyncExec(() -> SwtUtil.showError(title, msg, shellFinal));
        } else {
            SwtConfirmationDlg.error(title, msg, shellFinal);
        }
    }

    public static void showInfo(String title, String msg, Shell shell) {
        Shell shellFinal;
        Shell shell2 = shellFinal = SwtUtil.shellValid(shell) ? shell : new Shell();
        if (shellFinal.getDisplay().getThread() != Thread.currentThread()) {
            Display.getDefault().asyncExec(() -> SwtUtil.showInfo(title, msg, shellFinal));
        } else {
            SwtConfirmationDlg.info(title, msg, shellFinal);
        }
    }

    public static void showWarning(String title, String msg, Shell shell) {
        Shell shellFinal;
        Shell shell2 = shellFinal = SwtUtil.shellValid(shell) ? shell : new Shell();
        if (shellFinal.getDisplay().getThread() != Thread.currentThread()) {
            Display.getDefault().asyncExec(() -> SwtUtil.showWarning(title, msg, shellFinal));
        } else {
            SwtConfirmationDlg.warning(title, msg, shellFinal);
        }
    }

    public static org.eclipse.swt.graphics.Color toSwtColor(Color value) {
        if (value == null) {
            return null;
        }
        int alpha = 255 - value.getT();
        String valueString = String.format("r%dg%db%da%d", value.getR(), value.getG(), value.getB(), alpha);
        if (sSwtColors.containsKey(valueString)) {
            return sSwtColors.get(valueString);
        }
        Display display = Display.getCurrent();
        org.eclipse.swt.graphics.Color color = new org.eclipse.swt.graphics.Color((Device)display, value.getR(), value.getG(), value.getB(), alpha);
        sSwtColors.put(valueString, color);
        return color;
    }

    public static Color toIbeeColor(org.eclipse.swt.graphics.Color value) {
        if (value == null) {
            return null;
        }
        Color color = new Color(value.getRed(), value.getGreen(), value.getBlue(), value.getAlpha());
        return color;
    }

    private static boolean shellValid(Shell shell) {
        return shell != null && !shell.isDisposed();
    }

    public static Monitor getBestMonitor(Point location) {
        return SwtUtil.getBestMonitor(new Rectangle(location.x, location.y, 1, 1));
    }

    public static Monitor getBestMonitor(Rectangle rect) {
        Display display = Display.getCurrent();
        Monitor[] monitors = display.getMonitors();
        Monitor bestMonitor = display.getPrimaryMonitor();
        int maxOverlap = 0;
        Monitor[] monitorArray = monitors;
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            Rectangle monitorBounds = monitor.getBounds();
            Rectangle intersection = rect.intersection(monitorBounds);
            int overlap = intersection.width * intersection.height;
            if (overlap > maxOverlap) {
                maxOverlap = overlap;
                bestMonitor = monitor;
            }
            ++n2;
        }
        return bestMonitor;
    }
}

