/*
 * Decompiled with CFR 0.152.
 */
package net.edgemind.ibee.swt.core.util;

import net.edgemind.ibee.swt.core.util.SwtUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ToolTip {
    private final Shell tooltipShell;
    private final Label tooltipLabel;
    private boolean visible = false;

    public ToolTip(Display display) {
        this.tooltipShell = new Shell(display, 540676);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        this.tooltipShell.setLayout((Layout)layout);
        this.tooltipShell.setBackground(display.getSystemColor(29));
        this.tooltipShell.setForeground(display.getSystemColor(28));
        this.tooltipLabel = new Label((Composite)this.tooltipShell, 64);
        this.tooltipLabel.setBackground(display.getSystemColor(29));
        this.tooltipLabel.setForeground(display.getSystemColor(28));
    }

    public void setForegroundColor(Color color) {
        this.tooltipLabel.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.tooltipLabel.setBackground(color);
        this.tooltipShell.setBackground(color);
    }

    public void show(String text, Point location, boolean displayNextToLocation) {
        if (this.tooltipShell.isDisposed() || text == null || text.isEmpty()) {
            return;
        }
        this.tooltipLabel.setText(text);
        this.tooltipShell.pack();
        this.tooltipShell.setVisible(true);
        Rectangle screen = SwtUtil.getBestMonitor(location).getClientArea();
        Point toolTipLocation = new Point(location.x, location.y);
        Point size = this.tooltipShell.getSize();
        if (displayNextToLocation) {
            toolTipLocation.x += 15;
            toolTipLocation.y += 15;
        }
        boolean xAdapted = false;
        if (toolTipLocation.x + size.x > screen.x + screen.width) {
            toolTipLocation.x = screen.x + screen.width - size.x;
            xAdapted = true;
        }
        boolean yAdapted = false;
        if (toolTipLocation.y + size.y > screen.y + screen.height) {
            toolTipLocation.y = screen.y + screen.height - size.y;
            yAdapted = true;
        }
        if (xAdapted && yAdapted) {
            toolTipLocation.y = location.y - 15 - size.y;
        }
        this.tooltipShell.setLocation(toolTipLocation);
        this.visible = true;
    }

    public void hide() {
        if (!this.tooltipShell.isDisposed() && this.visible) {
            this.tooltipShell.setVisible(false);
            this.visible = false;
        }
    }

    public void dispose() {
        if (!this.tooltipShell.isDisposed()) {
            this.tooltipShell.dispose();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }
}

